package com.af.v4.system.plugins.calculate;

import com.af.v4.system.plugins.core.PriceFormatTools;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * caption 混合单价计算。 费用 = 气量*混合单价1比例*混合单价1 + 气量*混合单价2比例*混合单价2
 *
 * @author Lyf
 */
public class MixedPriceSettlement implements ISettlementInterface {

    @Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        //价格1的单价
        BigDecimal hybridPrice1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1")));
        //价格2的单价
        BigDecimal hybridPrice2 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice2")));
        //价格1的比例
        BigDecimal hybridPrice1rate = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_hybridprice1rate")));

        //费用 = 气量*混合单价1比例*混合单价1 + 气量*混合单价2比例*混合单价2
        BigDecimal gas1 = gas.multiply(hybridPrice1rate);
        BigDecimal gas2 = new BigDecimal("1").subtract(hybridPrice1rate).multiply(gas);
        BigDecimal chargeNum1 = gas1.multiply(hybridPrice1);
        BigDecimal chargeNum2 = gas2.multiply(hybridPrice2);
        PriceFormatTools.formatNumberBase(chargeNum1);
        PriceFormatTools.formatNumberBase(chargeNum2);
        BigDecimal chargeNum = chargeNum1.add(chargeNum2);

        JSONArray array = new JSONArray();
        //目前只支持两种
        JSONObject json = new JSONObject();
        json.put("f_price_name", "混合1");
        json.put("f_price", hybridPrice1);
        json.put("f_gas", gas1);
        json.put("f_money", chargeNum1);
        array.put(json);
        JSONObject json2 = new JSONObject();
        json2.put("f_price_name", "混合2");
        json2.put("f_price", hybridPrice2);
        json2.put("f_gas", gas2);
        json2.put("f_money", chargeNum2);
        array.put(json2);

        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("chargenum", chargeNum);
        return ret;
    }

    @Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        //价格1的单价
        BigDecimal hybridPrice1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get(
                "f_hybridprice1")));
        //价格2的单价
        BigDecimal hybridPrice2 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get(
                "f_hybridprice2")));
        //价格1的比例
        BigDecimal hybridPrice1rate = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0)
                .get("f_hybridprice1rate")));

        BigDecimal amount = fee.divide(
                hybridPrice1rate.multiply(hybridPrice1).add(
                        new BigDecimal("1").subtract(hybridPrice1rate).multiply(
                                hybridPrice2)), 0, RoundingMode.DOWN);

        JSONArray array = new JSONArray();
        //目前只支持两种
        JSONObject json = new JSONObject();
        json.put("f_price_name", "混合1");
        json.put("f_price", hybridPrice1);
        json.put("f_gas", amount);
        json.put("f_money", fee);
        array.put(json);
        JSONObject json2 = new JSONObject();
        json2.put("f_price_name", "混合2");
        json2.put("f_price", hybridPrice2);
        json2.put("f_gas", amount);
        json2.put("f_money", fee);
        array.put(json2);

        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("gas", amount);
        //格式化数字类型
        PriceFormatTools.formatNumber(ret);
        return ret;
    }
}
