package com.af.v4.system.common.websocket.handler;

import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.plugins.json.JsonTools;
import com.github.linyuzai.connection.loadbalance.core.concept.Connection;
import com.github.linyuzai.connection.loadbalance.core.concept.ConnectionLoadBalanceConcept;
import com.github.linyuzai.connection.loadbalance.core.message.Message;
import com.github.linyuzai.connection.loadbalance.websocket.concept.WebSocketConnection;
import com.github.linyuzai.connection.loadbalance.websocket.concept.WebSocketMessageHandler;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.net.URI;
import java.util.Map;

/**
 * 默认websocket消息处理器
 *
 * @author Mr.river
 */
@Component
public class DefaultMessageHandler implements WebSocketMessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageHandler.class);

    @Log(title = "Websocket调用Logic", businessType = BusinessType.LOGIC)
    @Override
    public void onMessage(Message message, Connection connection, ConnectionLoadBalanceConcept concept) {
        WebSocketConnection webSocketConnection = ((WebSocketConnection) connection);
        URI uri = webSocketConnection.getUri();
        String path = uri.getPath();
        String payLoad = message.getPayload();
        Map<String, String> queryParameterMap = webSocketConnection.getQueryParameterMap();
        String logicName = path.substring(path.lastIndexOf("/") + 1);
        JSONObject params;
        if (payLoad != null) {
            params = new JSONObject(payLoad);
        } else {
            params = new JSONObject();
        }
        if (queryParameterMap != null && !queryParameterMap.isEmpty()) {
            JsonTools.addJSON(params, new JSONObject(queryParameterMap));
        }
        SpringUtils.getBean(ILogicServiceProxy.class).run(logicName, params);
    }
}
