/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.websocket.handler;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.plugins.json.JsonTools;
import com.github.linyuzai.connection.loadbalance.core.concept.Connection;
import com.github.linyuzai.connection.loadbalance.core.message.Message;
import com.github.linyuzai.connection.loadbalance.core.message.MessageHandler;
import com.github.linyuzai.connection.loadbalance.websocket.concept.WebSocketConnection;
import java.net.URI;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultMessageHandler
implements MessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageHandler.class);

    public void onMessage(Message message, Connection connection) {
        WebSocketConnection webSocketConnection = (WebSocketConnection)connection;
        URI uri = webSocketConnection.getUri();
        String path = uri.getPath();
        String payLoad = (String)message.getPayload();
        Map queryParameterMap = webSocketConnection.getQueryParameterMap();
        String logicName = path.substring(path.lastIndexOf("/") + 1);
        JSONObject params = payLoad != null ? new JSONObject(payLoad) : new JSONObject();
        if (queryParameterMap != null && !queryParameterMap.isEmpty()) {
            JsonTools.addJSON((JSONObject)params, (JSONObject)new JSONObject(queryParameterMap));
        }
        ((LogicService)SpringUtils.getBean(LogicService.class)).run(logicName, params);
    }
}

