package com.af.v4.system.common.websocket.mqtt;

import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @Description mqtt配置类
 * @Author Eraser
 */

@Configuration
@ConfigurationProperties(MQTTConfigBuilder.PREFIX)
public class MQTTConfigBuilder {

    //配置的名称
    public static final String PREFIX = "publish.mqtt";
    /**
     * 服务端地址
     */
    private String host;

    /**
     * 客户端id
     */
    private String clientId;
    /**
     * 配置链接项
     */
    private MqttConnectOptions options;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public MqttConnectOptions getOptions() {
        return options;
    }

    public void setOptions(MqttConnectOptions options) {
        this.options = options;
    }

    @Override
    public String toString() {
        return "MQTTConfigBuilder{" +
                "host='" + host + '\'' +
                ", clientId='" + clientId + '\'' +
                ", options=" + options +
                '}';
    }
}

