package com.af.v4.system.common.task.config;

import java.util.Arrays;

public class DependencyChecker {
    public static boolean isJarPresent(String jarName) {
        String classPath = System.getProperty("java.class.path");
        return Arrays.stream(classPath.split(System.getProperty("path.separator")))
                .anyMatch(path -> path.contains(jarName));
    }

    public static void main(String[] args) {
        String jarName = "af-common-task";
        if (isJarPresent(jarName)) {
            System.out.println("依赖已引入: " + jarName);
        } else {
            System.out.println("依赖未引入: " + jarName);
        }
    }
}
