package com.af.v4.system.common.task.taskBefore.impl;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.plugins.json.JsonTools;
import com.af.v4.system.common.task.taskBefore.TaskRunBefore;
import com.af.v4.system.common.task.taskBefore.TaskType;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@TaskType("export")
public class ExportTaskRunBeforeImpl implements TaskRunBefore {

    @Autowired
    private LiuLiConfigService liuLiConfig;

    @Override
    public JSONObject exec(JSONObject data) {

        JSONObject queryParam = new JSONObject();
        Object tag1 = data.get("f_tag1");
        if (tag1 instanceof JSONObject) {
            queryParam = (JSONObject) tag1;
        } else if (tag1 instanceof String) {
            queryParam = JsonTools.convertToJson(String.valueOf(tag1));
        }
        JSONObject queryParams = liuLiConfig.get(queryParam.getString("queryParamsName"), true);
        data.put("f_param", String.valueOf(queryParams));

        return data;
    }
}
