/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.task.config;

import com.af.v4.system.common.task.taskBefore.TaskRunBefore;
import com.af.v4.system.common.task.taskBefore.TaskType;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TaskRunBeforeRegistry {
    private final Map<String, TaskRunBefore> TASK_MAP = new HashMap<String, TaskRunBefore>();
    private static final String DEFAULT_TYPE = "default";
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initialize() {
        Map beans = this.applicationContext.getBeansWithAnnotation(TaskType.class);
        for (Object bean : beans.values()) {
            TaskType annotation = bean.getClass().getAnnotation(TaskType.class);
            if (annotation == null) continue;
            String type = annotation.value();
            this.TASK_MAP.put(type, (TaskRunBefore)bean);
        }
        if (!this.TASK_MAP.containsKey(DEFAULT_TYPE)) {
            throw new IllegalStateException("\u5fc5\u987b\u63d0\u4f9b\u4e00\u4e2a\u6807\u8bc6\u4e3a 'default' \u7684\u9ed8\u8ba4\u5b9e\u73b0");
        }
    }

    public TaskRunBefore getTask(String type) {
        return this.TASK_MAP.getOrDefault(type, this.TASK_MAP.get(DEFAULT_TYPE));
    }
}

