package com.af.v4.system.common.task.taskBefore.impl;

import com.af.v4.system.common.core.proxy.liuli.ILiuLiConfigServiceProxy;
import com.af.v4.system.common.plugins.json.JsonTools;
import com.af.v4.system.common.task.taskBefore.TaskRunBefore;
import com.af.v4.system.common.task.taskBefore.TaskType;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
@TaskType("export")
public class ExportTaskRunBeforeImpl implements TaskRunBefore {

    private final ILiuLiConfigServiceProxy liuLiConfig;

    public ExportTaskRunBeforeImpl(ILiuLiConfigServiceProxy liuLiConfig) {
        this.liuLiConfig = liuLiConfig;
    }

    @Override
    public JSONObject exec(JSONObject data) {

        JSONObject queryParam = new JSONObject();
        Object tag1 = data.get("f_tag1");
        if (tag1 instanceof JSONObject) {
            queryParam = (JSONObject) tag1;
        } else if (tag1 instanceof String) {
            queryParam = JsonTools.convertToJson(String.valueOf(tag1));
        }
        JSONObject queryParams = liuLiConfig.get(queryParam.getString("queryParamsName"), true);
        data.put("f_param", String.valueOf(queryParams));

        return data;
    }
}
