package com.af.v4.system.common.task.config;

import com.af.v4.system.common.task.taskBefore.TaskRunBefore;
import com.af.v4.system.common.task.taskBefore.TaskType;
import jakarta.annotation.PostConstruct;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
public class TaskRunBeforeRegistry {

    private static final String DEFAULT_TYPE = "default";
    private final Map<String, TaskRunBefore> TASK_MAP = new HashMap<>();
    private final ApplicationContext applicationContext;

    public TaskRunBeforeRegistry(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void initialize() {
        Map<String, Object> beans = applicationContext.getBeansWithAnnotation(TaskType.class);
        for (Object bean : beans.values()) {
            TaskType annotation = bean.getClass().getAnnotation(TaskType.class);
            if (annotation != null) {
                String type = annotation.value();
                TASK_MAP.put(type, (TaskRunBefore) bean);
            }
        }
        // 确保有默认实现
        if (!TASK_MAP.containsKey(DEFAULT_TYPE)) {
            throw new IllegalStateException("必须提供一个标识为 'default' 的默认实现");
        }
    }

    // 根据类型获取实现类
    public TaskRunBefore getTask(String type) {
        return TASK_MAP.getOrDefault(type, TASK_MAP.get(DEFAULT_TYPE));
    }
}

