package com.af.v4.system.common.task;

import com.af.v4.system.common.core.utils.SpringUtils;
import org.json.JSONObject;

public class TaskAfter {

    public JSONObject exec(String class_, JSONObject param) throws ClassNotFoundException {

        // 截取 class_ 最后一位, 拼接获取反射数据
        String[] split = class_.split("\\.");
        String className = "com.af.v4.system.common.task.impl." + split[split.length - 1].replaceFirst("Handler", "After");
        Class<?> aClass = null;
        try {
            aClass = Class.forName(className);
        } catch (LinkageError | ClassNotFoundException e) {
            aClass = Class.forName("com.af.v4.system.common.task.impl.DefaultAfterImpl");
        }
        Object bean = SpringUtils.getBean(aClass);

        return ((TaskRunAfter) bean).runAfter(param);
    }

}
