package com.af.v4.system.common.task.entity;

import com.af.v4.system.common.task.entity.vo.TaskResult;
import org.springframework.stereotype.Component;

/**
 * 任务处理抽象类
 */
@Component
public interface TaskHandler {

    /**
     * 任务执行
     *
     * @param task 任务
     * @return 任务执行状态 结果
     */
    TaskResult<String> run(Task task, TaskHandler _this) throws Exception;

    /**
     * 中断
     *
     * @param taskId 任务id
     * @return 中断结果 成功返回 TaskStatus.INTERRUPT; 失败返回 TaskStatus.FAILED
     */
    TaskResult<String> interrupt(Integer taskId);

    void updateProgress(Integer id, String userId, double taskProgress, String taskType);
}
