/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.task.service;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.product.TaskProduct;
import com.af.v4.system.common.task.utils.LogicUtil;
import com.af.v4.system.common.task.utils.SerializationUtils;
import java.io.IOException;
import java.sql.Timestamp;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskService {
    public static final String CONFIG_NAME = "taskManagement";
    public static final String SERVICE_NAME = "af-task";
    public static boolean isLocal = true;
    private final Logger LOGGER = LoggerFactory.getLogger(TaskService.class);
    private final TaskProduct taskProduct;
    @Autowired
    private RedisService redisService;
    @Autowired
    private LogicService logicService;

    public TaskService(TaskProduct taskProduct) {
        this.taskProduct = taskProduct;
    }

    public void updateProgress(Integer id, String userId, double taskProgress, String taskType) {
        Boolean useWebSocket = !TaskProduct.config.has("taskType") || !TaskProduct.config.getJSONObject("taskType").has("useWebSocket") || TaskProduct.config.getJSONObject(taskType).optBoolean("useWebSocket", false);
        if (taskProgress < 0.0 || taskProgress > 1.0) {
            return;
        }
        LogicUtil.run(this.logicService, "taskUpdateProgress", String.valueOf(new JSONObject().put("id", (Object)id).put("f_user_id", (Object)userId).put("f_task_progress", taskProgress).put("useWebSocket", (Object)useWebSocket)), isLocal);
    }

    public JSONObject send(JSONObject data) throws IOException, ClassNotFoundException {
        int taskId;
        this.LOGGER.info(">>>> \u4efb\u52a1\u51c6\u5907\u6267\u884c: " + data.optString("f_task_name"));
        isLocal = TaskProduct.config.getJSONObject("taskType").getJSONObject(data.getString("f_task_type")).optBoolean("isLocal", true);
        Object f_param = data.opt("f_param");
        data.put("f_param", (Object)"");
        JSONObject taskSendRes = data;
        int TTL = TaskProduct.config.getJSONObject("taskType").getJSONObject(data.getString("f_task_type")).optInt("TTL", 3600000);
        if (!data.has("id")) {
            data.put("TTL", TTL);
            taskSendRes = (JSONObject)LogicUtil.run(this.logicService, "taskSend", data.toString(), isLocal);
            if (taskSendRes.getBoolean("isExist")) {
                return taskSendRes;
            }
        }
        if (!this.redisService.hasKey("TASK-" + (taskId = taskSendRes.optInt("id")) + "-param")) {
            this.redisService.set("TASK-" + taskId + "-param", (Object)SerializationUtils.serialize(f_param), (Object)TTL);
        }
        Timestamp f_create_time = taskSendRes.has("f_create_time") && taskSendRes.get("f_create_time") != null ? Timestamp.valueOf(taskSendRes.getString("f_create_time")) : new Timestamp(System.currentTimeMillis());
        Task task = new Task(taskSendRes.getString("f_task_name"), f_create_time, TaskStatus.PENDING.getStatus(), taskSendRes.getString("f_task_type"), taskSendRes.getString("f_task_class"), taskSendRes.getString("f_user_id"));
        task.setId(taskSendRes.getInt("id"));
        task.setTag1(data.opt("f_tag1"));
        task.setTag2(data.opt("f_tag2"));
        task.setTag3(data.opt("f_tag3"));
        task.setTag4(data.opt("f_tag4"));
        task.setTag5(data.opt("f_tag5"));
        task.setTag6(data.opt("f_tag6"));
        Object bean = SpringUtils.getBean(Class.forName(task.getTaskClass()));
        TaskResult<Task> taskTaskResult = this.taskProduct.publishEvent(task, (TaskHandler)bean);
        return Task.convertToJson(taskTaskResult.getData());
    }

    public TaskResult<String> interrupt(JSONObject data) {
        return this.taskProduct.interrupt(data.getInt("id"));
    }
}

