/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.impl;

import com.af.v4.system.common.excel.service.ExcelService;
import com.af.v4.system.common.impl.FileUploadTaskHandlerImpl;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.product.TaskProduct;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonExportHandlerImpl
implements TaskHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadTaskHandlerImpl.class);
    @Autowired
    private LogicService logicService;
    @Autowired
    private ExcelService excelService;

    @Override
    public TaskResult<String> run(Task task, TaskHandler that) throws Exception {
        TaskResult<String> taskResult = new TaskResult<String>();
        boolean useWebSocket = TaskProduct.config.getJSONObject("taskType").getJSONObject(task.getTaskType()).optBoolean("useWebSocket", false);
        JSONObject queryParam = new JSONObject().put("queryParam", (Object)String.valueOf(task.getTag1())).put("taskId", (Object)task.getId());
        JSONObject commonExport = (JSONObject)this.logicService.run("commonAsyncExport", String.valueOf(queryParam));
        String path = this.excelService.asyncExportExcelToServer((List)commonExport.get("dataList"), (JSONArray)commonExport.get("headList"), String.valueOf(task.getTag2()), (List)commonExport.get("customHeadMsg"), task.getId(), task.getUserId(), useWebSocket);
        JSONObject progressJson = new JSONObject().put("taskid", (Object)task.getId()).put("progress", 100);
        JSONArray userList = new JSONArray();
        userList.put((Object)task.getUserId());
        JSONObject param = new JSONObject().put("userList", (Object)userList).put("event", (Object)String.valueOf(progressJson));
        this.logicService.remoteRun("af-system", "sendMessage", String.valueOf(param));
        taskResult.setCode(200).setMsg(TaskStatus.SUCCESS).setData(path);
        return taskResult;
    }

    @Override
    public TaskResult<String> interrupt(Integer taskId) {
        return null;
    }

    @Override
    public void updateProgress(Integer id, String userId, double taskProgress, String taskType) {
    }
}

