package com.af.v4.system.common.task.utils;

import java.io.*;
import java.util.Base64;

public class SerializationUtils {

    public static String serialize(Object obj) throws IOException {

        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos)) {
            oos.writeObject(obj);
            return Base64.getEncoder().encodeToString(bos.toByteArray());
        }
    }

    public static Object deserialize(String str) throws IOException, ClassNotFoundException {

        byte[] bytes = Base64.getDecoder().decode(str);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
             ObjectInputStream ois = new ObjectInputStream(bis)) {
            return ois.readObject();
        }
    }

}
