package com.af.v4.system.common.task.entity;

import org.json.JSONObject;

import java.lang.reflect.Field;
import java.sql.Timestamp;

public class Task {

    private Integer id;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 创建时间
     */
    private Timestamp createTime;

    /**
     * 开始执行时间
     */
    private Timestamp startTime;

    /**
     * 结束时间
     */
    private Timestamp endTime;

    /**
     * 任务状态
     */
    private String taskStatus;

    /**
     * 任务类型
     */
    private String taskType;

    /**
     * 任务class
     */
    private String taskClass;

    /**
     * 执行结果
     */
    private String result;

    /**
     * 执行进度
     */
    private Double progress;
    private String userId;

    private Object param;

    /**
     * 用户
     */
    private Object tag1;
    private Object tag2;
    private Object tag3;
    private Object tag4;
    private Object tag5;
    private Object tag6;

    public Task() {
    }

    public Task(String taskName, Timestamp createTime, String taskStatus, String taskType, String taskClass, String userId) {
        this.taskName = taskName;
        this.createTime = createTime;
        this.taskStatus = taskStatus;
        this.taskType = taskType;
        this.taskClass = taskClass;
        this.userId = userId;
    }

    public static JSONObject convertToJson(Task task) {
        JSONObject jsonObject = new JSONObject();

        Field[] fields = Task.class.getDeclaredFields();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Object value = field.get(task);
                if (value != null) {
                    String fieldName = field.getName();
                    fieldName = "id".equals(fieldName) ? fieldName : "f_" + fieldName.replaceAll("([a-z0-9])([A-Z]+)", "$1_$2").toLowerCase();
                    jsonObject.put(fieldName, value);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return jsonObject;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Timestamp getStartTime() {
        return startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        return endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public String getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskClass() {
        return taskClass;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    public Timestamp getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }


    public Double getProgress() {
        return progress;
    }

    public void setProgress(Double progress) {
        this.progress = progress;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Object getTag1() {
        return tag1;
    }

    public void setTag1(Object tag1) {
        this.tag1 = tag1;
    }

    public Object getTag2() {
        return tag2;
    }

    public void setTag2(Object tag2) {
        this.tag2 = tag2;
    }

    public Object getTag3() {
        return tag3;
    }

    public void setTag3(Object tag3) {
        this.tag3 = tag3;
    }

    public Object getTag4() {
        return tag4;
    }

    public void setTag4(Object tag4) {
        this.tag4 = tag4;
    }

    public Object getTag5() {
        return tag5;
    }

    public void setTag5(Object tag5) {
        this.tag5 = tag5;
    }

    public Object getTag6() {
        return tag6;
    }

    public void setTag6(Object tag6) {
        this.tag6 = tag6;
    }

    public Object getParam() {
        return param;
    }

    public void setParam(Object param) {
        this.param = param;
    }
}
