package com.af.v4.system.common.impl;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.constant.ServiceNameConstants;
import com.af.v4.system.common.excel.service.ExcelService;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.product.TaskProduct;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 导出
 * taskType: commonExport
 * <p>
 * f_tag1 导出参数字符串
 */
@Component
public class CommonExportHandlerImpl implements TaskHandler {

    private final static Logger LOGGER = LoggerFactory.getLogger(FileUploadTaskHandlerImpl.class);

    @Autowired
    private LogicService logicService;

    @Autowired
    private ExcelService excelService;

    @Override
    public TaskResult<String> run(Task task, TaskHandler that) throws Exception {

        TaskResult<String> taskResult = new TaskResult<>();
        boolean useWebSocket = TaskProduct.config.getJSONObject("taskType").getJSONObject(task.getTaskType()).optBoolean("useWebSocket", false);
        JSONObject queryParam = new JSONObject().put("queryParam", String.valueOf(task.getTag1())).put("taskId", task.getId());
        JSONObject commonExport = (JSONObject) logicService.run("commonAsyncExport", String.valueOf(queryParam));
        String path = excelService.asyncExportExcelToServer(
                (List<Object>) commonExport.get("dataList"),
                (JSONArray) commonExport.get("headList"),
                String.valueOf(task.getTag2()),
                (List<String>) commonExport.get("customHeadMsg"),
                task.getId(),
                task.getUserId(),
                useWebSocket);


        JSONObject progressJson = new JSONObject()
                .put("taskid", task.getId())
                .put("progress", 100);
        JSONArray userList = new JSONArray();
        userList.put(task.getUserId());
        JSONObject param = new JSONObject()
                .put("userList", userList)
                .put("event", String.valueOf(progressJson));
        logicService.remoteRun(ServiceNameConstants.SYSTEM_SERVICE, "sendMessage", String.valueOf(param));

        taskResult.setCode(HttpStatus.SUCCESS).setMsg(TaskStatus.SUCCESS).setData(path);
        return taskResult;
    }

    @Override
    public TaskResult<String> interrupt(Integer taskId) {
        return null;
    }

    @Override
    public void updateProgress(Integer id, String userId, double taskProgress, String taskType) {

    }
}
