package com.af.v4.system.common.controller;


import com.af.v4.system.common.task.service.TaskService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.Map;

@RestController
@RequestMapping("/file")
public class FileUploadController {

    static Logger log = LoggerFactory.getLogger(FileUploadController.class);

    @Autowired
    private TaskService taskService;

    private final String[] saveField = new String[]{
            "f_blobid", "f_businessid", "f_filename", "f_stock_id", "f_table_name",
            "f_filetype", "f_use_type", "f_file_size", "f_remarks", "f_operator",
            "f_orgid", "defname", "f_state", "f_form_type", "f_username",
            "fusetype", "fremarks", "f_parentname", "f_fengongsi"
    };

    @PostMapping("/saveFileForm")
    public String saveFile(@RequestParam("file") MultipartFile file,
                           @RequestParam Map<String, String> fileDetail) {

        log.info(">>>> 上传表单");
        JSONObject fileDetailJSON = new JSONObject(fileDetail);
        if (file.getSize() == 0) {
            throw new RuntimeException("上传文件大小为0");
        }
        JSONObject saveFile = new JSONObject();
        for (String field : saveField) {
            saveFile.put(field, fileDetail.get(field));
        }
        saveFile.put("f_file_size", file.getSize());

        try {
            fileDetailJSON.put("f_param", file.getBytes());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        fileDetailJSON.put("f_tag6", saveFile.toString());

        JSONObject send = null;
        try {
            send = taskService.send(fileDetailJSON);
        } catch (IOException | ClassNotFoundException e) {
            log.error("表单上传失败: ", e);
            throw new RuntimeException(e);
        }

        return send.toString();
    }
}
