package com.af.v4.system.common.task.entity.vo;

import com.af.v4.system.common.task.enums.TaskStatus;

public class TaskResult<T> {

    private int code;
    private TaskStatus msg;
    private T data;

    public TaskResult() {
    }

    public TaskResult(TaskStatus msg, T data) {
        this.msg = msg;
        this.data = data;
    }

    @Override
    public String toString() {
        return "TaskResult{" +
                "code=" + code +
                ", msg=" + msg +
                ", data=" + data +
                '}';
    }

    public TaskStatus getMsg() {
        return msg;
    }

    public TaskResult<T> setMsg(TaskStatus msg) {
        this.msg = msg;
        return this;
    }

    public T getData() {
        return data;
    }

    public TaskResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public TaskResult<T> setCode(int code) {
        this.code = code;
        return this;
    }

}
