/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.task.consumer;

import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.event.TaskEvent;
import com.af.v4.system.common.task.product.TaskProduct;
import com.lmax.disruptor.WorkHandler;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class TaskManageHandler
implements WorkHandler<TaskEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskManageHandler.class);
    public static final String TASK_MANAGER_TABLE = "t_task_management";
    public static final String TASK_EXECUTE_LOG = "t_task_execute_log";
    public static final Map<Integer, Thread> threadMap = new HashMap<Integer, Thread>();
    @Autowired
    private RedisService redisService;
    @Autowired
    private LogicService logicService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(TaskEvent event) {
        TaskHandler taskHandler = event.getTemplateTaskHandler();
        Task task = event.getTemplateTask();
        LOGGER.info(">>>> \u4efb\u52a1\u6d88\u8d39\u5f00\u59cb: " + task.getTaskName());
        JSONObject taskJson = ((JSONArray)this.logicService.run("taskGetByQuery", String.valueOf(new JSONObject().put("query", (Object)("id = '" + task.getId() + "'"))))).getJSONObject(0);
        if (TaskStatus.INTERRUPT.getStatus().equals(taskJson.getString("f_task_status"))) {
            return;
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        task.setTaskStatus(TaskStatus.RUNNING.getStatus());
        task.setStartTime(timestamp);
        task.setProgress(0.0);
        this.logicService.run("taskSave", Task.convertToJson(task));
        try {
            threadMap.put(task.getId(), Thread.currentThread());
            if (!this.redisService.hasKey("TASK-" + task.getId() + "-param")) {
                task.setTaskStatus(TaskStatus.FAILED.getStatus());
                task.setResult("\u4efb\u52a1\u4e22\u5931");
                throw new RuntimeException();
            }
            String param = (String)this.redisService.get("TASK-" + task.getId() + "-param");
            task.setParam(param);
            TaskResult<String> res = taskHandler.run(task, taskHandler);
            if (res.getMsg().equals((Object)TaskStatus.SUCCESS)) {
                System.out.println(">>>> \u6d88\u8d39\u7ed3\u675f \u5220\u9664redis\u6570\u636e: TASK-" + task.getId() + "-param");
                this.redisService.delete("TASK-" + task.getId() + "-param");
            }
            task.setTaskStatus(res.getMsg().getStatus());
            task.setResult(res.getData().toString());
        }
        catch (Exception e) {
            LOGGER.info(">>>> \u4efb\u52a1\u6d88\u8d39\u5f02\u5e38" + task.getTaskName());
            task.setTaskStatus(TaskStatus.FAILED.getStatus());
            e.printStackTrace();
        }
        finally {
            task.setParam(null);
            TaskProduct.taskIdRinBufferSequence.remove(task.getId());
            threadMap.remove(task.getId());
            Timestamp endTime = new Timestamp(System.currentTimeMillis());
            task.setEndTime(endTime);
            task.setProgress(1.0);
            this.logicService.run("taskSave", Task.convertToJson(task));
            LOGGER.info(">>>> \u4efb\u52a1\u6d88\u8d39\u7ed3\u675f: " + task.getTaskName());
        }
    }
}

