package com.af.v4.system.common.impl;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.product.TaskProduct;
import com.af.v4.system.common.task.service.TaskService;
import com.af.v4.system.common.task.utils.SerializationUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 文件上传默认实现
 */

@Component
public class FileUploadTaskHandlerImpl implements TaskHandler {

    private final static Logger LOGGER = LoggerFactory.getLogger(FileUploadTaskHandlerImpl.class);

    private final String TASK_TYPE = "saveFile";

    @Autowired
    private EntityService entityService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private LiuLiConfigService liuLiConfigService;

    @Override
    public TaskResult<String> run(Task task, TaskHandler _this) throws Exception {

        LOGGER.info(">>>> 任务开始执行 " + task.getTaskName());
        // 获取JSONArray 从redis中获取后返回
        byte[] imageData = (byte[]) SerializationUtils.deserialize(task.getParam().toString());

        String filename = (String) task.getTag1();

        String filePath = getFilePath() + File.separator + filename;
        File file = new File(filePath);

        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        // 发送进度
        Integer taskId = task.getId();
        String userId = task.getUserId();
        updateProgress(taskId, userId, 0.8, task.getTaskType());
        try (FileOutputStream fos = new FileOutputStream(file)) {
            fos.write(imageData);
            updateProgress(taskId, userId, 1, task.getTaskType());
        } catch (IOException e) {
            LOGGER.error(">>>> 保存图片错误: " + e.getMessage());
            return new TaskResult<String>(TaskStatus.FAILED, e.getMessage());
        }

        JSONObject map = new JSONObject();
        map.put("f_filename", filename);
        String uploaddate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        map.put("f_uploaddate", uploaddate);
        map.put("f_filetype", filename.split("\\.")[1]);
        map.put("f_realpath", filePath);
        map.put("f_downloadpath", filePath);

        String dataSource = TaskProduct.config.getJSONObject("taskType").getJSONObject(task.getTaskType()).optString("dataSource", "master");
        DynamicDataSource.withDataSource(dataSource, () -> {
            try {
                return entityService.partialSave("t_files", map);
            } catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        LOGGER.info(">>>> 任务执行结束" + task.getTaskName());
        return new TaskResult<String>(TaskStatus.SUCCESS, filePath);
    }

    @Override
    public TaskResult<String> interrupt(Integer taskId) {
        return null;
    }

    @Override
    public void updateProgress(Integer id, String userId, double taskProgress, String taskType) {
        taskService.updateProgress(id, userId, taskProgress, taskType);
    }

    private String getFilePath() {
        JSONObject config = liuLiConfigService.get(TaskService.CONFIG_NAME);
        return config.getJSONObject("taskType").getJSONObject(TASK_TYPE).optString("filePath", "D:\\upload");
    }
}
