/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.task.product;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.task.consumer.TaskManageHandler;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.event.TaskEvent;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.WorkerPool;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TaskProduct {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskProduct.class);
    private static RingBuffer<TaskEvent> ringBuffer;
    public static Map<Integer, Long> taskIdRinBufferSequence;
    public static final Integer DEFAULT_BUFFER_SIZE;
    public static JSONObject config;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private LiuLiConfigService liuLiConfigService;
    @Autowired
    private LogicService logicService;

    @PostConstruct
    public void init() {
        config = this.liuLiConfigService.get("taskManagement");
        int corePoolSize = config.getInt("corePoolSize");
        int maximumPoolSize = config.getInt("maximumPoolSize");
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadFactory(this){
            private int counter = 0;

            @Override
            public Thread newThread(Runnable r) {
                String prefix = "TASK";
                return new Thread(r, prefix + "-" + this.counter++);
            }
        });
        WorkHandler[] consumers = new TaskManageHandler[maximumPoolSize];
        for (int i = 0; i < consumers.length; ++i) {
            TaskManageHandler taskManageHandler;
            consumers[i] = taskManageHandler = (TaskManageHandler)this.applicationContext.getBean(TaskManageHandler.class);
        }
        ringBuffer = RingBuffer.create((ProducerType)ProducerType.MULTI, TaskEvent::new, (int)DEFAULT_BUFFER_SIZE, (WaitStrategy)new YieldingWaitStrategy());
        SequenceBarrier barrier = ringBuffer.newBarrier(new Sequence[0]);
        WorkerPool workerPool = new WorkerPool(ringBuffer, barrier, (ExceptionHandler)new IgnoreExceptionHandler(), consumers);
        ringBuffer.addGatingSequences(workerPool.getWorkerSequences());
        RingBuffer start = workerPool.start((Executor)executor);
    }

    public TaskResult<Task> publishEvent(Task task, TaskHandler taskHandler) {
        long sequence = ringBuffer.next();
        TaskEvent event = (TaskEvent)ringBuffer.get(sequence);
        event.setTemplateTaskHandler(taskHandler);
        event.setTemplateTask(task);
        taskIdRinBufferSequence.put(task.getId(), sequence);
        ringBuffer.publish(sequence);
        return new TaskResult<Task>(TaskStatus.SUCCESS, task).setCode(200);
    }

    public TaskResult<String> interrupt(Integer id) throws IOException, ClassNotFoundException {
        TaskResult<String> taskResult = new TaskResult<String>(TaskStatus.SUCCESS, "");
        Long sequence = taskIdRinBufferSequence.get(id);
        if (sequence == null) {
            taskResult.setMsg(TaskStatus.SUCCESS).setData("\u4efb\u52a1\u5df2\u6267\u884c\u5b8c\u6210");
            return taskResult;
        }
        TaskEvent taskEvent = (TaskEvent)ringBuffer.get(sequence.longValue());
        TaskResult<String> taskInterrupt = taskEvent.interruptTask(id);
        if (taskInterrupt.getMsg().getStatus().equals(TaskStatus.INTERRUPT.getStatus())) {
            Thread thread = TaskManageHandler.threadMap.get(id);
            if (thread != null) {
                thread.interrupt();
            } else {
                ringBuffer.removeGatingSequence(new Sequence(sequence.longValue()));
            }
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            Task task = new Task();
            task.setId(id);
            task.setEndTime(timestamp);
            task.setTaskStatus(TaskStatus.INTERRUPT.getStatus());
            task.setProgress(0.0);
            this.logicService.remoteRun("af-task", "taskSave", String.valueOf(new JSONObject().put("t_task_management", (Object)Task.convertToJson(task))));
            this.logicService.remoteRun("af-task", "taskExecuteSave", String.valueOf(new JSONObject().put("t_task_execute_log", (Object)new JSONObject().put("f_task_id", (Object)task.getId()).put("f_time", (Object)timestamp).put("f_progress", 0.0).put("f_task_status", (Object)task.getTaskStatus()))));
            taskIdRinBufferSequence.remove(id);
            TaskManageHandler.threadMap.remove(id);
        }
        return taskResult;
    }

    static {
        taskIdRinBufferSequence = new HashMap<Integer, Long>();
        DEFAULT_BUFFER_SIZE = 0x100000;
        config = new JSONObject();
    }
}

