/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.impl;

import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.service.TaskService;
import com.af.v4.system.common.task.utils.SerializationUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileUploadTaskHandlerImpl
implements TaskHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadTaskHandlerImpl.class);
    private final String TASK_TYPE = "saveFile";
    @Autowired
    private EntityService entityService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private LiuLiConfigService liuLiConfigService;

    @Override
    public TaskResult<String> run(Task task, TaskHandler _this) throws Exception {
        byte[] imageData = (byte[])SerializationUtils.deserialize(task.getParam().toString());
        String filename = (String)task.getTag1();
        String filePath = this.getFilePath() + File.separator + filename;
        File file = new File(filePath);
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        Integer taskId = task.getId();
        String userId = task.getUserId();
        this.updateProgress(taskId, userId, 0.8, task.getTaskType());
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(imageData);
            this.updateProgress(taskId, userId, 1.0, task.getTaskType());
        }
        catch (IOException e) {
            LOGGER.error(">>>> \u4fdd\u5b58\u56fe\u7247\u9519\u8bef: " + e.getMessage());
            return new TaskResult<String>(TaskStatus.FAILED, e.getMessage());
        }
        JSONObject map = new JSONObject(task.getTag6().toString());
        map.put("f_filename", (Object)filename);
        String uploaddate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        map.put("f_uploaddate", (Object)uploaddate);
        map.put("f_filetype", (Object)filename.split("\\.")[1]);
        map.put("f_realpath", (Object)filePath);
        map.put("f_downloadpath", (Object)filePath);
        this.entityService.partialSave("t_files", map);
        return new TaskResult<CallSite>(TaskStatus.SUCCESS, (CallSite)((Object)filePath));
    }

    @Override
    public TaskResult<String> interrupt(Integer taskId) {
        return null;
    }

    @Override
    public void updateProgress(Integer id, String userId, double taskProgress, String taskType) {
        this.taskService.updateProgress(id, userId, taskProgress, taskType);
    }

    private String getFilePath() {
        JSONObject config = this.liuLiConfigService.get("taskManagement");
        return config.getJSONObject("taskType").getJSONObject("saveFile").optString("filePath", "D:\\upload");
    }
}

