/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.task.service;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.product.TaskProduct;
import com.af.v4.system.common.task.utils.InvokeUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class TaskService
implements InitializingBean {
    public static final String CONFIG_NAME = "taskManagement";
    public static JSONObject config;
    static Logger LOGGER;
    private final TaskProduct taskProduct;

    public TaskService(TaskProduct taskProduct, LiuLiConfigService liuLiConfigService) {
        this.taskProduct = taskProduct;
        config = liuLiConfigService.get(CONFIG_NAME);
    }

    public static void updateProgress(Integer id, String userId, double taskProgress) {
        if (taskProgress < 0.0 || taskProgress > 1.0) {
            return;
        }
        LOGGER.info(">>>> \u66f4\u65b0\u8fdb\u5ea6: " + id + "-" + taskProgress);
        RestTools.post((String)(TaskProduct.serverAddress + "/taskUpdateProgress"), (JSONObject)new JSONObject().put("id", (Object)id).put("f_user_id", (Object)userId).put("f_task_progress", taskProgress));
    }

    public JSONObject send(JSONObject data) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        LOGGER.info(">>>> \u53d1\u8d77\u4efb\u52a1: " + String.valueOf(data));
        JSONObject taskSendRes = data;
        if (!data.has("f_task_group_id")) {
            data.put("f_address", (Object)config.getString("address")).put("f_app_name", (Object)config.getString("appName"));
            String sendRes = RestTools.post((String)(TaskProduct.serverAddress + "/taskSend"), (JSONObject)data);
            data = new JSONObject(sendRes).getJSONObject("data");
            taskSendRes = data.getJSONObject("data");
            if (data.getBoolean("isExist")) {
                return taskSendRes;
            }
        }
        Timestamp f_create_time = taskSendRes.has("f_create_time") ? Timestamp.valueOf(taskSendRes.getString("f_create_time")) : new Timestamp(System.currentTimeMillis());
        Task task = new Task(taskSendRes.getString("f_task_name"), f_create_time, TaskStatus.PENDING.getStatus(), taskSendRes.getString("f_task_type"), taskSendRes.getString("f_task_class"), taskSendRes.getString("f_param"), taskSendRes.getString("f_user_id"));
        task.setTaskGroupId(taskSendRes.getInt("f_task_group_id"));
        task.setId(taskSendRes.getInt("id"));
        TaskResult<Task> taskTaskResult = this.taskProduct.publishEvent(task, (TaskHandler)InvokeUtil.createInstance(task.getTaskClass()));
        return Task.convertToJson(taskTaskResult.getData());
    }

    public TaskResult<String> interrupt(JSONObject data) throws IOException, ClassNotFoundException {
        LOGGER.info(">>>> \u4e2d\u65ad\u4efb\u52a1: " + String.valueOf(data));
        return this.taskProduct.interrupt(data.getInt("id"));
    }

    public void afterPropertiesSet() {
        String register = RestTools.post((String)(TaskProduct.serverAddress + "/taskClientRegister"), (JSONObject)new JSONObject().put("address", (Object)config.getString("address")).put("appName", (Object)config.getString("appName")));
        try {
            if (new JSONObject(register).getInt("code") != 200) {
                throw new RuntimeException("\u4efb\u52a1\u670d\u52a1\u6ce8\u518c\u5931\u8d25, \u672a\u542f\u52a8task\u670d\u52a1\u7aef");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(TaskService.class);
    }
}

