package com.af.v4.system.common.task.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvokeUtil {

    /**
     * 反射创建 实例
     *
     * @param className 类包路径
     * @return 实例
     */
    public static Object createInstance(String className)
            throws ClassNotFoundException, NoSuchMethodException,
            IllegalAccessException, InstantiationException,
            InvocationTargetException {

        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor();
        return constructor.newInstance();
    }

    /**
     * 反射执行
     *
     * @param className className 类包路径
     * @param args      参数
     * @return 执行结果
     */
    public static Object invokeMethod(String className, String methodName, Object... args) throws Exception {

        Class<?> clazz = Class.forName(className);
        Object instance = clazz.getDeclaredConstructor().newInstance();

        Method method = null;
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getName().equals(methodName)) {
                method = m;
                break;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("Method " + methodName + " not found in class " + className);
        }

        return method.invoke(instance, args);
    }

}
