package com.af.v4.system.common.task.enums;

public enum TaskStatus {

    ADD("新增任务"),
    PENDING("执行中-等待队列"), // 进入队列，当存在消费者空闲时立即执行
    RUNNING("执行中"),
    SUCCESS("执行成功"),
    FAILED("执行失败"),
    INTERRUPT("已中断");

    private final String status;

    TaskStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return status;
    }

    public static TaskStatus getByStatus(String status) {
        for (TaskStatus taskStatus : TaskStatus.values()) {
            if (taskStatus.status.equals(status)) {
                return taskStatus;
            }
        }
        return null;
    }

    public static String toString(TaskStatus status) {
        return status != null ? status.getStatus() : null;
    }

}
