package com.af.v4.system.common.task.entity;

import com.af.v4.system.common.task.entity.vo.TaskResult;

/**
 * 任务处理抽象类
 */
public interface TaskHandler {

    /**
     * 任务执行
     *
     * @param task 任务
     * @return 任务执行状态 结果
     */
    TaskResult<String> run(Task task) throws Exception;

    /**
     * 中断
     *
     * @param taskId 任务id
     * @return 中断结果 成功返回 TaskStatus.INTERRUPT; 失败返回 TaskStatus.FAILED
     */
    TaskResult<String> interrupt(Integer taskId);

}
