package com.af.v4.system.common.task.entity;

import org.json.JSONObject;

import java.lang.reflect.Field;
import java.sql.Timestamp;

public class Task {

    private Integer id;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 创建时间
     */
    private Timestamp createTime;

    /**
     * 开始执行时间
     */
    private Timestamp startTime;

    /**
     * 结束时间
     */
    private Timestamp endTime;

    /**
     * 任务状态
     */
    private String taskStatus;

    /**
     * 任务类型
     */
    private String taskType;

    /**
     * 任务class
     */
    private String taskClass;

    /**
     * 任务参数
     */
    private String param;

    /**
     * 执行结果
     */
    private String result;

    /**
     * 执行进度
     */
    private Double progress;

    /**
     * 用户
     */
    private String userId;

    /**
     * 执行器id
     */
    private Integer taskGroupId;

    public Task() {
    }

    public Task(String taskName, Timestamp createTime, String taskStatus, String taskType, String taskClass, String param, String userId) {
        this.taskName = taskName;
        this.createTime = createTime;
        this.taskStatus = taskStatus;
        this.taskType = taskType;
        this.taskClass = taskClass;
        this.param = param;
        this.userId = userId;
    }

    public static JSONObject convertToJson(Task task) {
        JSONObject jsonObject = new JSONObject();

        Field[] fields = Task.class.getDeclaredFields();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Object value = field.get(task);
                if (value != null) {
                    String fieldName = field.getName();
                    fieldName = "id".equals(fieldName) ? fieldName : "f_" + fieldName.replaceAll("([a-z0-9])([A-Z]+)", "$1_$2").toLowerCase();
                    jsonObject.put(fieldName, value);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return jsonObject;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Timestamp getStartTime() {
        return startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        return endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public String getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskClass() {
        return taskClass;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    public Timestamp getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public String getParam() {
        return param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }


    public Double getProgress() {
        return progress;
    }

    public void setProgress(Double progress) {
        this.progress = progress;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Integer getTaskGroupId() {
        return taskGroupId;
    }

    public void setTaskGroupId(Integer taskGroupId) {
        this.taskGroupId = taskGroupId;
    }
}