package com.af.v4.system.common.task.consumer;

import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.task.entity.Task;
import com.af.v4.system.common.task.entity.TaskHandler;
import com.af.v4.system.common.task.entity.vo.TaskResult;
import com.af.v4.system.common.task.enums.TaskStatus;
import com.af.v4.system.common.task.event.TaskEvent;
import com.af.v4.system.common.task.product.TaskProduct;
import com.lmax.disruptor.WorkHandler;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/**
 * 任务消息处理器
 * <p>
 * WorkHandler 处理重复消费
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class TaskManageHandler implements WorkHandler<TaskEvent> {

    private final static Logger LOGGER = LoggerFactory.getLogger(TaskManageHandler.class);

    public final static String TASK_MANAGER_TABLE = "t_task_management";
    public final static String TASK_EXECUTE_LOG = "t_task_execute_log";
    public final static Map<Integer, Thread> threadMap = new HashMap<>();

    @Override
    public void onEvent(TaskEvent event) {

        TaskHandler taskHandler = event.getTemplateTaskHandler();
        Task task = event.getTemplateTask();
        LOGGER.info(">>>> 开始执行任务: " + task.getTaskName() + " - " + task.getTaskClass());

        String taskGetByIdRes = RestTools.post(TaskProduct.serverAddress + "/taskGetByQuery", new JSONObject()
                .put("query", "id = '" + task.getId() + "'"));
        JSONObject taskJson = new JSONObject(taskGetByIdRes).getJSONArray("data").getJSONObject(0);
        if (TaskStatus.INTERRUPT.getStatus().equals(taskJson.getString("f_task_status"))) {
            return;
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        task.setTaskStatus(TaskStatus.RUNNING.getStatus());
        task.setStartTime(timestamp);
        task.setProgress(0.0);

        RestTools.post(TaskProduct.serverAddress + "/taskSave", new JSONObject()
                .put(TaskManageHandler.TASK_MANAGER_TABLE, Task.convertToJson(task)));
        RestTools.post(TaskProduct.serverAddress + "/taskExecuteSave", new JSONObject()
                .put(TaskManageHandler.TASK_EXECUTE_LOG, new JSONObject()
                        .put("f_task_id", task.getId())
                        .put("f_time", timestamp)
                        .put("f_progress", 0.0)
                        .put("f_task_status", task.getTaskStatus())));

        try {
            threadMap.put(task.getId(), Thread.currentThread());
            TaskResult<String> res = taskHandler.run(task);
            task.setTaskStatus(res.getMsg().getStatus());
            task.setResult(res.getData().toString());
        } catch (Exception e) {
            task.setTaskStatus(TaskStatus.INTERRUPT.getStatus());
            e.printStackTrace();
        } finally {
            LOGGER.info(">>>> " + task.getId() + "执行结束, 执行结果: " + task.getTaskStatus());
            TaskProduct.taskIdRinBufferSequence.remove(task.getId());
            threadMap.remove(task.getId());

            Timestamp endTime = new Timestamp(System.currentTimeMillis());
            task.setEndTime(endTime);
            task.setProgress(1.0);
            RestTools.post(TaskProduct.serverAddress + "/taskSave", new JSONObject()
                    .put(TaskManageHandler.TASK_MANAGER_TABLE, Task.convertToJson(task)));
            RestTools.post(TaskProduct.serverAddress + "/taskExecuteSave", new JSONObject()
                    .put(TaskManageHandler.TASK_EXECUTE_LOG, new JSONObject()
                            .put("f_task_id", task.getId())
                            .put("f_time", timestamp)
                            .put("f_task_status", task.getTaskStatus())));
        }

    }
}
