package com.af.v4.system.common.socket.core.server.modbus.message;


import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.core.server.modbus.util.FunctionCodeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPModbusMessageFactory {

    public static final short PROTOCOLID = 0;
    private final static Logger LOGGER = LoggerFactory.getLogger(TCPModbusMessageFactory.class);

    // 组织 读线圈头数据
    public static MBAPHeader newReadReqHeader(ClientEvent event) {
        byte uuid = 1;
        short length = 6; // uuid(1) + code(1) + start(2) + num(2)
        MBAPHeader mbapHeader = new MBAPHeader();
        mbapHeader.setTransactionId(event.getTransactionId());
        mbapHeader.setProtocolId(PROTOCOLID);
        mbapHeader.setUnitId(uuid);
        mbapHeader.setLength(length);
        return mbapHeader;
    }

    // 组织 读线圈数据体
    public static PduPayload newReadCoilsReqPdu(ClientEvent event) {
        PduPayload pduPayload = new PduPayload();

        String address = event.getAddress();//寄存器起始地址
        int quantity = event.getLength();//寄存器的数量
        short bytelength = 4;
        byte[] pduBytes = new byte[4];
        //pdu
        pduPayload.setFunctionCode((short) FunctionCodeConstants.ReadCoils);
        pduPayload.setDataLength(bytelength);
        ConvertTools.copyBytes(pduBytes, ConvertTools.hexStrToByte(address), 0);
        ConvertTools.copyBytes(pduBytes, ConvertTools.intToBytesBig(quantity), 2);
        try {
            pduPayload.setData(pduBytes);
        } catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            // 处理异常，直接返回或者记录日志，后续代码不再执行
            return null;
        }
        return pduPayload;
    }

    // 组织读寄存器数据体
    public static PduPayload newReadHoldingRegistersReqPdu(ClientEvent event) {
        PduPayload pduPayload = new PduPayload();
        String address = event.getAddress();//寄存器起始地址
        int quantity = event.getLength();//寄存器的数量
        short bytelength = 4;
        byte[] pduBytes = new byte[4];
        pduPayload.setFunctionCode(FunctionCodeConstants.ReadHoldingRegisters);
        pduPayload.setDataLength(bytelength);
        ConvertTools.copyBytes(pduBytes, ConvertTools.hexStrToByte(address), 0);
        ConvertTools.copyBytes(pduBytes, ConvertTools.intToBytesBig(quantity), 2);
        try {
            pduPayload.setData(pduBytes);
        } catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            // 处理异常，直接返回或者记录日志，后续代码不再执行
            return null;
        }
        return pduPayload;
    }

    //构建 00 03 00 00 00 06 01... //TODO demo
    public static MBAPHeader newWriteSingleCoilReqHeader() {
        byte uuid = 1;
        short transactionId = 3;
        short length = 6; // uuid(1) + code(1) + start(2) + num(2)
        MBAPHeader mbapHeader = new MBAPHeader();
        mbapHeader.setTransactionId(transactionId);
        mbapHeader.setProtocolId(PROTOCOLID);
        mbapHeader.setUnitId(uuid);
        mbapHeader.setLength(length);
        return mbapHeader;
    }

    //TODO demo
    public static PduPayload newWriteSingleCoilReqPdu() {
        PduPayload pduPayload = new PduPayload();
        String address = "00AC";//寄存器起始地址
        int values = 1;//写入的数值
        short bytelength = 4;
        byte[] pduBytes = new byte[4];
        pduPayload.setFunctionCode(FunctionCodeConstants.WriteSingleCoil);
        pduPayload.setDataLength(bytelength);
        ConvertTools.copyBytes(pduBytes, ConvertTools.hexStrToByte(address), 0);
        ConvertTools.copyBytes(pduBytes, ConvertTools.intToBytesBig(values), 2);
        try {
            pduPayload.setData(pduBytes);
        } catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            // 处理异常，直接返回或者记录日志，后续代码不再执行
            return null;
        }
        return pduPayload;
    }

    //构建 00 04 00 00 00 06 01... //TODO demo
    public static MBAPHeader newWriteSingleRegisterReqHeader() {
        byte uuid = 1;
        short transactionId = 4;
        short length = 6; // uuid(1) + code(1) + start(2) + num(2)
        MBAPHeader mbapHeader = new MBAPHeader();
        mbapHeader.setTransactionId(transactionId);
        mbapHeader.setProtocolId(PROTOCOLID);
        mbapHeader.setUnitId(uuid);
        mbapHeader.setLength(length);
        return mbapHeader;
    }

    //TODO demo
    public static PduPayload newWriteSingleRegisterReqPdu() {
        PduPayload pduPayload = new PduPayload();
        String address = "00AC";//寄存器起始地址
        int values = 27;//写入的数值
        short bytelength = 4;
        byte[] pduBytes = new byte[4];
        pduPayload.setFunctionCode(FunctionCodeConstants.WriteSingleRegister);
        pduPayload.setDataLength(bytelength);
        ConvertTools.copyBytes(pduBytes, ConvertTools.hexStrToByte(address), 0);
        ConvertTools.copyBytes(pduBytes, ConvertTools.intToBytesBig(27), 2);

        try {
            pduPayload.setData(pduBytes);
        } catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            // 处理异常，直接返回或者记录日志，后续代码不再执行
            return null;
        }
        return pduPayload;
    }
}
