/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.mqtt;

import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.MqttServerChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketServer;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import jakarta.annotation.PreDestroy;

public class MqttServer
extends SocketServer<ServerBootstrap, ServerChannel> {
    private static final int MAX_INCOMING_MESSAGE_SIZE = 0x100000;
    private final SocketConfigItem configItem;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public MqttServer(SocketConfigItem configItem) {
        this.configItem = configItem;
    }

    @Override
    protected AbstractBootstrap<ServerBootstrap, ServerChannel> initBootstrap() {
        Class<EpollServerSocketChannel> channelClass;
        if (ApplicationUtils.getOSType() == OSTypeEnum.LINUX) {
            this.bossGroup = new EpollEventLoopGroup();
            this.workerGroup = new EpollEventLoopGroup();
            channelClass = EpollServerSocketChannel.class;
        } else {
            this.bossGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
            channelClass = NioServerSocketChannel.class;
        }
        try {
            ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(channelClass)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE).addLast("decoder", (ChannelHandler)new MqttDecoder(0x100000)).addLast(new ChannelHandler[]{new MqttServerChannelHandler(MqttServer.this.configItem)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
            return serverBootstrap;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.destroy();
            return null;
        }
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

