package com.af.v4.system.common.socket.core.client.tcp;

import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.ByteBufChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import jakarta.annotation.PreDestroy;

/**
 * TCP客户端
 */
public class TcpClient extends SocketClient<ServerChannel> {
    private EventLoopGroup group;

    @Override
    protected Bootstrap initBootstrap(SocketClientConfigItem socketConfigItem) {
        Class<? extends Channel> channelClass;
        if (ApplicationUtils.getOSType() == OSTypeEnum.LINUX) {
            group = new EpollEventLoopGroup();
            channelClass = EpollSocketChannel.class;
        } else {
            group = new NioEventLoopGroup();
            channelClass = NioSocketChannel.class;
        }

        return new Bootstrap()
                .group(group)
                .channel(channelClass)
                .handler(new ChannelInitializer<SocketChannel>() {
                    @Override
                    protected void initChannel(SocketChannel ch) {
                        ch.pipeline().addLast(new ByteBufChannelHandler());
                    }
                });
    }

    @PreDestroy
    public void destroy() {
        if (group != null) {
            group.shutdownGracefully();
        }
    }

    @Override
    public void senMes(SocketClientConfigItem socketClientConfigItem) {
    }
}
