package com.af.v4.system.common.socket.core.client;

import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.mqtt.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChannelManager {
    /**
     * 全局map，保存通道
     */
    private static final ConcurrentHashMap<String, Channel> channelMap = new ConcurrentHashMap<>(128);

    public static ConcurrentHashMap<String, Channel> getChannelMap() {
        return channelMap;
    }

    //保存MQTT订阅地址和chanelid,当推送数据时，会向此订阅地址的多个channel发送数据
    public static ConcurrentHashMap<String, List<ChannelId>> subscribeMap = new ConcurrentHashMap();

    //保存设备名称和通道编号，向设备发送消息可以通过名称找到通道
    public static Map<String, String> MQTTdeviceMap = new ConcurrentHashMap<>();

    //存放Qos2消息等级的消息ID，这里可使用redis之类的工具做持久化，为了简化开发，使用map暂存
    public static ConcurrentHashMap<Integer, MqttMessage> mqttMessageIdMap = new ConcurrentHashMap();

    private static final Logger log = LoggerFactory.getLogger(ChannelManager.class);

    /**
     * 获取channel
     */
    public static Channel getChannel(String channelId) {
        if (CollectionUtils.isEmpty(channelMap)) {
            return null;
        }
        return channelMap.get(channelId);
    }

    /**
     * 添加channel
     */
    public static void add(SocketClientConfigItem socketClientConfigItem, Channel channel) {
        channelMap.put(socketClientConfigItem.getAddress(),channel);
    }

    /**
     * 添加服务端channel
     */
    public static void add(ChannelId channelId, Channel channel) {
        channelMap.put(String.valueOf(channelId), channel);
    }

    /**
     * 移除channel
     */
    public static boolean removeChannel(String channelId) {
        if (channelMap.containsKey(channelId)) {
            channelMap.remove(channelId);
            return true;
        }
        return false;
    }

    /**
     * 设备移除和订阅的topic
     */
    public static void MQTTremoveChannel(ChannelId channelId) {
        if (channelMap.containsKey(channelId)) {
            channelMap.remove(channelId);
            // 去除对应设备名称项
            MQTTdeviceMap.entrySet().removeIf(item -> item.getValue().equals(channelId));
            ;
            //移除topic中的这个设备的chanelid
            for (Map.Entry<String, List<ChannelId>> listEntry : subscribeMap.entrySet()) {
                try {
                    if (listEntry.getValue().contains(channelId)) {
                        listEntry.getValue().remove(channelId);
                        log.info(channelId + "下线,topic:  " + listEntry.getKey() + "中移除此id");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 返回channel列表
     *
     * @return
     */
    public static List<String> list() {
        List<String> list = new ArrayList<>();
        if (CollectionUtils.isEmpty(channelMap)) {
            return null;
        }
        for (Map.Entry<String, Channel> iterator : channelMap.entrySet()) {
            String channelId = iterator.getKey();
            Channel channel = iterator.getValue();
            list.add(channelId);
        }
        return list;

    }
}
