package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.AbstractChannelHandler;
import com.af.v4.system.common.socket.core.client.ClientManager;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;

public class DatagramPacketChannelHandler extends AbstractChannelHandler<DatagramPacket> {

    private final Logger LOGGER = LoggerFactory.getLogger(DatagramPacketChannelHandler.class);

    @Override
    protected void read(ChannelHandlerContext ctx, DatagramPacket message) {
        SocketConfigItem configItem = ClientManager.getConfig();
        String address = configItem.getType().equals(SocketTypeEnum.UDP) || ctx.channel().remoteAddress() == null ? message.sender().toString() : ctx.channel().remoteAddress().toString();
        Object response = runBusiness(message.content(), address);
        if (response == null || response.equals("ok") || response.equals("6f6b")) {
            return;
        }
        String responseStr = response.toString();
        byte[] respBytes = switch (configItem.getEncodeType()) {
            case BASE64 -> ConvertTools.base64Decode(responseStr.getBytes());
            case HEX -> ConvertTools.hexStrToByte(responseStr);
            case HEX_BASE64 -> ConvertTools.base64Decode(ConvertTools.hexStrToByte(responseStr));
            default -> responseStr.getBytes(StandardCharsets.UTF_8);
        };
        DatagramPacket packet = new DatagramPacket(new UnpooledByteBufAllocator(true).buffer().writeBytes(respBytes), message.sender());
        ctx.writeAndFlush(packet);
    }
}
