package com.af.v4.system.common.socket.core.channel;

import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.SocketServerManager;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.client.ClientManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetSocketAddress;
import java.util.Arrays;

public abstract class AbstractChannelHandler<T> extends SimpleChannelInboundHandler<T> {

    private final Logger LOGGER = LoggerFactory.getLogger(AbstractChannelHandler.class);

    @Override
    protected abstract void channelRead0(ChannelHandlerContext ctx, T msg);

    protected Object runBusiness(ByteBuf content, String remoteAddress) {
        SocketConfigItem configItem = ClientManager.getConfig();
        byte[] data = new byte[content.readableBytes()];
        content.readBytes(data);
        LOGGER.info("数据原始体：{}", Arrays.toString(data));
        String realData;
        try {
            realData = switch (configItem.getDecodeType()) {
                default -> ConvertTools.bytesToStr(data);
                case HEX -> ConvertTools.byteToHexStr(data);
            };
        } catch (Exception e) {
            LOGGER.error("数据解析失败：", e);
            return null;
        }

        JSONObject params = new JSONObject();
        params.put("value", realData);
        params.put("address", remoteAddress);

        try {
            return SpringUtils.getBean(LogicService.class).run(configItem.getLogicName(), params);
        } catch (Exception e) {
            if (e instanceof LogicException ex) {
                LOGGER.error("请求来源'{}',发生业务异常.\n{}", remoteAddress, ex.getStack());
            } else {
                LOGGER.error("请求来源'{}',发生服务端异常.", remoteAddress, e);
            }
            throw e;
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String channelId = ctx.channel().id().asLongText();
        LOGGER.info("成功建立连接,channelId：{}", channelId);
        String port = String.valueOf(((InetSocketAddress) ctx.channel().localAddress()).getPort());
        SocketConfigItem configItem = SocketServerManager.getSocketConfigItemByPort(port);
        ClientManager.add(new ChannelData(configItem, ctx.channel(), new JSONObject()));
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            ClientManager.remove();
            ctx.close();
        } catch (Exception e) {
            LOGGER.error("关闭通道时发生异常", e);
        }
        super.channelInactive(ctx);
    }
}
