/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.core.channel.AbstractChannelHandler;
import com.af.v4.system.common.socket.core.client.modbus.ModBusClient;
import com.af.v4.system.common.socket.core.server.modbus.message.MBAPHeader;
import com.af.v4.system.common.socket.core.server.modbus.message.PduPayload;
import com.af.v4.system.common.socket.core.server.modbus.util.MBAPHeaderDecoder;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTCPChannelHandler
extends AbstractChannelHandler<DefaultByteBufHolder> {
    public static final int HEADER_LENGTH = 8;
    private final Logger LOGGER = LoggerFactory.getLogger(ModbusTCPChannelHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DefaultByteBufHolder msg) {
        int totalLen = msg.content().readableBytes();
        if (totalLen < 8) {
            this.LOGGER.info("not modbus TCP protocol:");
            return;
        }
        MBAPHeader mbapHeader = MBAPHeaderDecoder.decode(msg.content());
        PduPayload pduPayload = new PduPayload();
        short functionCode = msg.content().readUnsignedByte();
        pduPayload.setFunctionCode(functionCode);
        int dataLength = 0;
        if (totalLen > 8) {
            dataLength = totalLen - 8;
        }
        pduPayload.setDataLength((short)dataLength);
        byte[] data = new byte[dataLength];
        msg.content().readBytes(data);
        try {
            pduPayload.setData(data);
        }
        catch (IllegalArgumentException e) {
            this.LOGGER.error(e.getMessage());
            return;
        }
        ClientEvent event = ModBusClient.modBusEventMap.get(mbapHeader.getTransactionId());
        String _data = switch (event.getDecodeType()) {
            default -> Arrays.toString(pduPayload.getRealData());
            case MsgTypeEnum.FLOAT -> Float.toString(ConvertTools.bytesToFloat((byte[])pduPayload.getRealData()));
            case MsgTypeEnum.BYTE_TO_SCALED_INT -> Integer.toString(ConvertTools.bytesToInt((byte[])pduPayload.getRealData(), (int)0));
        };
        JSONObject logicParam = new JSONObject();
        logicParam.put("event", (Object)event);
        logicParam.put(event.getAlias(), (Object)_data);
        ((LogicService)SpringUtils.getBean(LogicService.class)).run(event.getLogicName(), logicParam);
    }
}

