//package com.af.v4.system.common.socket.core.client.mqtt.message;
//
//import com.af.v4.system.common.socket.core.channel.ChannelData;
//import com.af.v4.system.common.socket.core.channel.impl.MqttClientChannelHandler;
//import io.netty.buffer.ByteBuf;
//import io.netty.buffer.ByteBufAllocator;
//import io.netty.channel.Channel;
//import io.netty.channel.ChannelHandlerContext;
//import io.netty.handler.codec.mqtt.*;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import java.nio.charset.StandardCharsets;
//import java.util.Collections;
//import java.util.concurrent.atomic.AtomicInteger;
//
//import static io.netty.handler.codec.mqtt.MqttQoS.AT_LEAST_ONCE;
//
///**
// * @Description
// * @Author Eraser
// */
//
//public class MqttClientUtils {
//
//    private static final Logger log = LoggerFactory.getLogger(MqttClientUtils.class);
//
//    // 记录消息id的变量，id值范围1~65535
//    private final AtomicInteger nextMessageId = new AtomicInteger(1);
//
//    /**
//     * 主动发送消息
//     *
//     * @param topic   :主题名称
//     * @param message ：消息体
//     * @param qos     ： 服务质量等级
//     * @param retain  ：
//     *                true:表示发送的消息需要一直持久保存（不受服务器重启影响），不但要发送给当前的订阅者，并且以后新来的订阅了此Topic name的订阅者会马上得到推送。
//     *                false:仅仅为当前订阅者推送此消息。
//     */
//    public void publish(String topic, String message, int qos, boolean retain) {
//        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.valueOf(qos), retain, 0);
//        MqttPublishVariableHeader variableHeader = new MqttPublishVariableHeader(topic, getNewMessageId().messageId());
//        // 创建 ByteBuf 分配器
//        ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
//        // 将字符串转换为 ByteBuf
//        ByteBuf byteBuf = allocator.buffer();
//        byteBuf.writeCharSequence(message, StandardCharsets.UTF_8);
//        MqttPublishMessage mqttPublishMessage = new MqttPublishMessage(fixedHeader, variableHeader, byteBuf);
//        //将消息发送给订阅的客户端
//        ChannelHandlerContext context = MqttClientChannelHandler.context;
//        if (context != null && context.channel().isActive()) {
//            context.writeAndFlush(mqttPublishMessage);
//        } else {
//            log.error("发送消息提醒：服务端连接异常~");
//        }
//    }
//
//    /**
//     * 功能描述: 获取消息id，int数，从1开始不能大于65535
//     *
//     * @param
//     * @return io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader
//     */
//    private MqttMessageIdVariableHeader getNewMessageId() {
//        int messageId;
//        synchronized (this.nextMessageId) {
//            this.nextMessageId.compareAndSet(0xffff, 1);
//            messageId = this.nextMessageId.getAndIncrement();
//        }
//        return MqttMessageIdVariableHeader.from(messageId);
//    }
//
//
//    /**
//     * 订阅主题
//     *
//     * @param topicName :主题名称
//     * @param qos       ：服务端可以向此客户端发送的应用消息的最大QoS等级
//     */
//    public void subscribe(String topicName, int qos) {
//        //构造固定头
//        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, AT_LEAST_ONCE, false, 0);
//        MqttMessageIdVariableHeader variableHeader = getNewMessageId();
//        //构造消息体,这里构建采用简单的模式（MqttTopicSubscription(String topicFilter, MqttQoS qualityOfService)）
//        // 如果想用更复杂的，使用（MqttTopicSubscription(String topicFilter, MqttSubscriptionOption option)）
//        MqttTopicSubscription subscription = new MqttTopicSubscription(topicName, MqttQoS.valueOf(qos));
//        MqttSubscribePayload payload = new MqttSubscribePayload(Collections.singletonList(subscription));
//        MqttSubscribeMessage mqttSubscribeMessage = new MqttSubscribeMessage(fixedHeader, variableHeader, payload);
//        ChannelHandlerContext context = MqttClientChannelHandler.context;
//        if (context != null && context.channel().isActive()) {
//            //发送消息，异步发送
//            context.writeAndFlush(mqttSubscribeMessage);
//        } else {
//            log.error("订阅提醒：服务端连接异常~");
//        }
//    }
//
//    /**
//     * 取消订阅主题
//     *
//     * @param topicName
//     */
//    public void unsubscribe(String topicName) {
//        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, AT_LEAST_ONCE, false, 0);
//        MqttMessageIdVariableHeader variableHeader = getNewMessageId();
//        MqttUnsubscribePayload payload = new MqttUnsubscribePayload(Collections.singletonList(topicName));
//        MqttUnsubscribeMessage mqttUnsubscribeMessage = new MqttUnsubscribeMessage(fixedHeader, variableHeader,
//                payload);
//        ChannelHandlerContext context = MqttClientChannelHandler.context;
//        if (context != null && context.channel().isActive()) {
//            //发送消息
//                context.writeAndFlush(mqttUnsubscribeMessage);
//        } else {
//            log.error("取消订阅提醒：服务端连接异常~");
//        }
//    }
//}
