/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client.tcp;

import com.af.v4.system.common.core.enums.OSType;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.core.channel.impl.ByteBufChannelHandler;
import com.af.v4.system.common.socket.core.client.SocketClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import jakarta.annotation.PreDestroy;

public class TcpClient
extends SocketClient {
    private EventLoopGroup group;

    @Override
    protected Bootstrap initBootstrap() {
        Class<EpollSocketChannel> channelClass;
        if (ApplicationService.getOSType() == OSType.LINUX) {
            this.group = new EpollEventLoopGroup();
            channelClass = EpollSocketChannel.class;
        } else {
            this.group = new NioEventLoopGroup();
            channelClass = NioSocketChannel.class;
        }
        return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(channelClass)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ByteBufChannelHandler()});
            }
        });
    }

    @Override
    @PreDestroy
    public void destroy() {
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }

    @Override
    public void senMes(SocketClientConfigItem socketClientConfigItem) {
    }
}

