/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client.mqtt;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;

public class MQTTMessageContext {
    public static final Cache<@NonNull String, MqttMessage> MQTT_MESSAGE_ID_MAP = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public static boolean hasKey(String messageId) {
        return MQTT_MESSAGE_ID_MAP.asMap().containsKey(messageId);
    }

    public static void put(String messageId, MqttMessage mqttMessage) {
        MQTT_MESSAGE_ID_MAP.put((Object)messageId, (Object)mqttMessage);
    }

    public static void remove(String messageId) {
        MQTT_MESSAGE_ID_MAP.invalidate((Object)messageId);
    }

    public static MqttMessage get(String messageId) {
        return (MqttMessage)MQTT_MESSAGE_ID_MAP.getIfPresent((Object)messageId);
    }
}

