/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.modbus.message;

import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.ClientEvent;
import com.af.v4.system.common.socket.core.server.modbus.message.MBAPHeader;
import com.af.v4.system.common.socket.core.server.modbus.message.PduPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPModbusMessageFactory {
    public static final short PROTOCOLID = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCPModbusMessageFactory.class);

    public static MBAPHeader newReadReqHeader(ClientEvent event) {
        byte uuid = 1;
        short length = 6;
        MBAPHeader mbapHeader = new MBAPHeader();
        mbapHeader.setTransactionId(event.getTransactionId());
        mbapHeader.setProtocolId((short)0);
        mbapHeader.setUnitId(uuid);
        mbapHeader.setLength(length);
        return mbapHeader;
    }

    public static PduPayload newReadCoilsReqPdu(ClientEvent event) {
        PduPayload pduPayload = new PduPayload();
        String address = event.getAddress();
        int quantity = event.getLength();
        short bytelength = 4;
        byte[] pduBytes = new byte[4];
        pduPayload.setFunctionCode(1);
        pduPayload.setDataLength(bytelength);
        ConvertTools.copyBytes((byte[])pduBytes, (byte[])ConvertTools.hexStrToByte((String)address), (int)0);
        ConvertTools.copyBytes((byte[])pduBytes, (byte[])ConvertTools.intToBytesBig((int)quantity), (int)2);
        try {
            pduPayload.setData(pduBytes);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        return pduPayload;
    }

    public static PduPayload newReadHoldingRegistersReqPdu(ClientEvent event) {
        PduPayload pduPayload = new PduPayload();
        String address = event.getAddress();
        int quantity = event.getLength();
        short bytelength = 4;
        byte[] pduBytes = new byte[4];
        pduPayload.setFunctionCode(3);
        pduPayload.setDataLength(bytelength);
        ConvertTools.copyBytes((byte[])pduBytes, (byte[])ConvertTools.hexStrToByte((String)address), (int)0);
        ConvertTools.copyBytes((byte[])pduBytes, (byte[])ConvertTools.intToBytesBig((int)quantity), (int)2);
        try {
            pduPayload.setData(pduBytes);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        return pduPayload;
    }

    public static MBAPHeader newWriteSingleCoilReqHeader() {
        byte uuid = 1;
        short transactionId = 3;
        short length = 6;
        MBAPHeader mbapHeader = new MBAPHeader();
        mbapHeader.setTransactionId(transactionId);
        mbapHeader.setProtocolId((short)0);
        mbapHeader.setUnitId(uuid);
        mbapHeader.setLength(length);
        return mbapHeader;
    }

    public static PduPayload newWriteSingleCoilReqPdu() {
        PduPayload pduPayload = new PduPayload();
        String address = "00AC";
        int values = 1;
        short bytelength = 4;
        byte[] pduBytes = new byte[4];
        pduPayload.setFunctionCode(5);
        pduPayload.setDataLength(bytelength);
        ConvertTools.copyBytes((byte[])pduBytes, (byte[])ConvertTools.hexStrToByte((String)address), (int)0);
        ConvertTools.copyBytes((byte[])pduBytes, (byte[])ConvertTools.intToBytesBig((int)values), (int)2);
        try {
            pduPayload.setData(pduBytes);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        return pduPayload;
    }

    public static MBAPHeader newWriteSingleRegisterReqHeader() {
        byte uuid = 1;
        short transactionId = 4;
        short length = 6;
        MBAPHeader mbapHeader = new MBAPHeader();
        mbapHeader.setTransactionId(transactionId);
        mbapHeader.setProtocolId((short)0);
        mbapHeader.setUnitId(uuid);
        mbapHeader.setLength(length);
        return mbapHeader;
    }

    public static PduPayload newWriteSingleRegisterReqPdu() {
        PduPayload pduPayload = new PduPayload();
        String address = "00AC";
        int values = 27;
        short bytelength = 4;
        byte[] pduBytes = new byte[4];
        pduPayload.setFunctionCode(6);
        pduPayload.setDataLength(bytelength);
        ConvertTools.copyBytes((byte[])pduBytes, (byte[])ConvertTools.hexStrToByte((String)address), (int)0);
        ConvertTools.copyBytes((byte[])pduBytes, (byte[])ConvertTools.intToBytesBig((int)27), (int)2);
        try {
            pduPayload.setData(pduBytes);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        return pduPayload;
    }
}

