/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server;

import com.af.v4.system.common.socket.config.SocketConfigItem;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketServer<B extends AbstractBootstrap<B, C>, C extends Channel> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public void run(SocketConfigItem socketConfigItem) {
        String socketType = socketConfigItem.getType().getValue();
        this.LOGGER.info("Netty: \u521d\u59cb\u5316{}\u670d\u52a1\u7aef[{}],\u76d1\u542c\u7aef\u53e3{},\u56de\u8c03\u4e1a\u52a1\u903b\u8f91\u540d[{}]", new Object[]{socketType, socketConfigItem.getName(), socketConfigItem.getPorts(), socketConfigItem.getLogicName()});
        AbstractBootstrap<B, C> bootstrap = this.initBootstrap();
        socketConfigItem.getPorts().forEach(port -> {
            try {
                ChannelFuture channelFuture = bootstrap.bind(Integer.parseInt(port.toString())).sync();
                channelFuture.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> future.channel().close()));
                this.allChannels.add((Object)channelFuture.channel());
            }
            catch (Exception e) {
                this.LOGGER.error("\u542f\u52a8{}\u670d\u52a1\u7aef[{}]\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", new Object[]{socketType, socketConfigItem.getName(), e.getMessage()});
                throw new RuntimeException("\u670d\u52a1\u7aef\u542f\u52a8\u5931\u8d25", e);
            }
        });
    }

    protected abstract AbstractBootstrap<B, C> initBootstrap();

    public abstract void destroy();

    protected void closeAllChannels() {
        try {
            this.allChannels.close().awaitUninterruptibly();
            this.LOGGER.info("\u6240\u6709\u901a\u9053\u5df2\u5173\u95ed");
        }
        catch (Exception e) {
            this.LOGGER.error("\u5173\u95ed\u6240\u6709\u5df2\u7ed1\u5b9a\u901a\u9053\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }
}

