/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client.mqtt;

import com.af.v4.system.common.socket.core.client.ClientManager;
import io.netty.channel.ChannelId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MQTTSubscribeManager {
    private static final Map<String, List<ChannelId>> subscribeMap = new ConcurrentHashMap<String, List<ChannelId>>();

    public static boolean hasSubscribe(String topicName) {
        return subscribeMap.containsKey(topicName);
    }

    public static void registerSubscribe(String topicName, List<ChannelId> channelId) {
        subscribeMap.put(topicName, channelId);
    }

    public static List<ChannelId> getSubscribe(String topicName) {
        return subscribeMap.get(topicName);
    }

    public static void removeSubscribe(String topicName, ChannelId channelId) {
        subscribeMap.get(topicName).remove(channelId);
    }

    public static Map<String, List<ChannelId>> getSubscribeMap() {
        return subscribeMap;
    }

    public static void MQTTRemoveChannel(ChannelId channelId) {
        if (ClientManager.isExistChannel(channelId)) {
            ClientManager.remove(channelId);
            for (Map.Entry<String, List<ChannelId>> listEntry : subscribeMap.entrySet()) {
                listEntry.getValue().remove(channelId);
            }
        }
    }
}

