/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client;

import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.core.client.ClientManager;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SocketClient
extends Bootstrap {
    protected final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void connect(SocketClientConfigItem socketConfigItem) {
        String socketType = socketConfigItem.getType().getValue();
        this.LOGGER.info("Netty: \u8fde\u63a5{}\u670d\u52a1\u7aef[{}], \u5730\u5740{}", new Object[]{socketType, socketConfigItem.getName(), socketConfigItem.getAddress()});
        Bootstrap bootstrap = this.initBootstrap();
        try {
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(socketConfigItem.getConnectionTimeout() * 1000));
            ChannelFuture channelFuture = bootstrap.connect((SocketAddress)new InetSocketAddress(socketConfigItem.getHost(), (int)socketConfigItem.getPort())).sync();
            if (channelFuture.isSuccess()) {
                Channel channel = channelFuture.channel();
                channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    ClientManager.remove(future.channel().id());
                    future.channel().close();
                }));
                ClientManager.add(channel.id().asLongText(), new ChannelData(socketConfigItem, channel, new JSONObject()));
                this.senMes(socketConfigItem);
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u8fde\u63a5{}\u670d\u52a1\u7aef[{}]\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", new Object[]{socketType, socketConfigItem.getName(), e.getMessage()});
            throw new RuntimeException("\u670d\u52a1\u7aef\u8fde\u63a5\u5931\u8d25", e);
        }
    }

    protected abstract Bootstrap initBootstrap();

    public abstract void destroy();

    public abstract void senMes(SocketClientConfigItem var1);
}

