/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client;

import cn.hutool.cache.impl.TimedCache;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.util.HashedWheelTimer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientManager.class);
    private static final TimedCache<String, ChannelData> clientChannels = new TimedCache(600000L, new ConcurrentHashMap());
    private static final ScopedValue<String> CHANNEL_SCOPED_VALUE = ScopedValue.newInstance();
    private static volatile HashedWheelTimer TIMER;
    private static final ReentrantLock LOCK;

    public static ScopedValue<String> getChannelScopedValue() {
        return CHANNEL_SCOPED_VALUE;
    }

    private static HashedWheelTimer getTimer() {
        if (TIMER == null) {
            LOCK.lock();
            try {
                if (TIMER == null) {
                    TIMER = new HashedWheelTimer();
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return TIMER;
    }

    public static void add(String channelId, ChannelData channelData) {
        clientChannels.put((Object)channelId, (Object)channelData);
    }

    public static void send(String message) {
        String channelId = CHANNEL_SCOPED_VALUE.get();
        ChannelData channelData = (ChannelData)clientChannels.get((Object)channelId);
        Channel channel = channelData.channel();
        if (channel != null) {
            byte[] sendMsgBytes = switch (channelData.configItem().getEncodeType()) {
                case MsgTypeEnum.BASE64 -> ConvertTools.base64Decode((byte[])message.getBytes());
                case MsgTypeEnum.HEX -> ConvertTools.hexStrToByte((String)message);
                case MsgTypeEnum.HEX_BASE64 -> ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)message));
                default -> message.getBytes();
            };
            channel.writeAndFlush((Object)channel.alloc().buffer().writeBytes(sendMsgBytes));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("channelId:{}, \u670d\u52a1\u7aef\u56de\u5e94\u6570\u636e:{}", (Object)channelId, (Object)message);
            }
        }
    }

    public static void delayedSend(String message, Integer sleepTime) {
        ClientManager.getTimer().newTimeout(timeout -> ClientManager.send(message), sleepTime.longValue(), TimeUnit.MILLISECONDS);
    }

    public static SocketConfigItem getConfig() {
        return ClientManager.getChannelData().configItem();
    }

    public static ChannelData getChannelData() {
        String channelId = CHANNEL_SCOPED_VALUE.get();
        return (ChannelData)clientChannels.get((Object)channelId);
    }

    public static boolean isExistChannel(ChannelId channelId) {
        return clientChannels.containsKey((Object)channelId.asLongText());
    }

    public static Channel getChannel(ChannelId channelId) {
        ChannelData channelData = (ChannelData)clientChannels.get((Object)channelId.asLongText());
        return channelData.channel();
    }

    public static void remove(ChannelId channelId) {
        clientChannels.remove((Object)channelId.asLongText());
    }

    public static void setGlobalParams(String key, Object value) {
        ChannelData channelData = ClientManager.getChannelData();
        JSONObject globalParamsItem = channelData.globalParams();
        globalParamsItem.put(key, value);
    }

    public static Object getGlobalParams(String key) {
        ChannelData channelData = ClientManager.getChannelData();
        JSONObject globalParamsItem = channelData.globalParams();
        return globalParamsItem.opt(key);
    }

    static {
        LOCK = new ReentrantLock();
    }
}

