/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.channel.impl.mqtt;

import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.ChannelData;
import com.af.v4.system.common.socket.core.client.ClientManager;
import com.af.v4.system.common.socket.core.client.mqtt.MQTTMessageContext;
import com.af.v4.system.common.socket.core.client.mqtt.MQTTSubscribeManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMsgBack {
    private static final Logger log = LoggerFactory.getLogger(MqttMsgBack.class);

    private static MqttConnAckMessage getMqttConnAckMessage(MqttConnectReturnCode connectionAccepted, MqttConnectVariableHeader mqttConnectVariableHeaderInfo, MqttFixedHeader mqttFixedHeaderInfo) {
        MqttConnAckVariableHeader mqttConnAckVariableHeaderBack = new MqttConnAckVariableHeader(connectionAccepted, mqttConnectVariableHeaderInfo.isCleanSession());
        MqttFixedHeader mqttFixedHeaderBack = new MqttFixedHeader(MqttMessageType.CONNACK, mqttFixedHeaderInfo.isDup(), MqttQoS.AT_MOST_ONCE, mqttFixedHeaderInfo.isRetain(), 2);
        return new MqttConnAckMessage(mqttFixedHeaderBack, mqttConnAckVariableHeaderBack);
    }

    private static MqttSubAckMessage getMqttSubAckMessage(Set<String> topics, MqttSubscribeMessage mqttSubscribeMessage, MqttMessageIdVariableHeader variableHeaderBack) {
        ArrayList<Integer> grantedQoSLevels = new ArrayList<Integer>(topics.size());
        for (int i = 0; i < topics.size(); ++i) {
            grantedQoSLevels.add(((MqttTopicSubscription)mqttSubscribeMessage.payload().topicSubscriptions().get(i)).qualityOfService().value());
        }
        MqttSubAckPayload payloadBack = new MqttSubAckPayload(grantedQoSLevels);
        MqttFixedHeader mqttFixedHeaderBack = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 2 + topics.size());
        return new MqttSubAckMessage(mqttFixedHeaderBack, variableHeaderBack, payloadBack);
    }

    public void connect(Channel channel, MqttMessage mqttMessage, SocketConfigItem configItem, boolean exist) {
        MqttConnectReturnCode connectionAccepted;
        MqttConnectMessage mqttConnectMessage = (MqttConnectMessage)mqttMessage;
        MqttFixedHeader mqttFixedHeaderInfo = mqttConnectMessage.fixedHeader();
        MqttConnectVariableHeader mqttConnectVariableHeaderInfo = mqttConnectMessage.variableHeader();
        String connectUsername = mqttConnectMessage.payload().userName();
        String connectPassword = new String(mqttConnectMessage.payload().passwordInBytes(), StandardCharsets.UTF_8);
        if (exist) {
            connectionAccepted = MqttConnectReturnCode.CONNECTION_REFUSED_BANNED;
            this.disconnack(channel);
        } else if (configItem.getUsername().equals(connectUsername) && configItem.getPassword().equals(connectPassword)) {
            connectionAccepted = MqttConnectReturnCode.CONNECTION_ACCEPTED;
            log.info("\u8bbe\u5907\u4e0a\u7ebf ==> [channelId:{},clientId:{}", (Object)channel.id(), (Object)(mqttConnectMessage.payload().clientIdentifier() + "]"));
            ClientManager.add(channel.id().asLongText(), new ChannelData(configItem, channel, new JSONObject()));
        } else {
            connectionAccepted = MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USERNAME_OR_PASSWORD;
            log.info(">>> \u8bbe\u5907\u8fde\u63a5\u5931\u8d25,\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u548c\u5bc6\u7801! <<<");
        }
        MqttConnAckMessage connAck = MqttMsgBack.getMqttConnAckMessage(connectionAccepted, mqttConnectVariableHeaderInfo, mqttFixedHeaderInfo);
        channel.writeAndFlush((Object)connAck);
    }

    public void disconnack(Channel channel) {
        log.info("\u8bbe\u5907\u4e0b\u7ebf ==> channelId: [{}]", (Object)channel.id());
        MQTTSubscribeManager.MQTTRemoveChannel(channel.id());
    }

    public void puback(Channel channel, MqttMessage mqttMessage) {
        MqttPublishMessage mqttPublishMessage = (MqttPublishMessage)mqttMessage;
        MqttFixedHeader mqttFixedHeaderInfo = mqttPublishMessage.fixedHeader();
        MqttQoS qos = mqttFixedHeaderInfo.qosLevel();
        byte[] headBytes = new byte[mqttPublishMessage.payload().readableBytes()];
        mqttPublishMessage.payload().readBytes(headBytes);
        mqttPublishMessage.payload().resetReaderIndex();
        switch (qos) {
            case AT_MOST_ONCE: {
                this.subscribSend(mqttMessage);
                break;
            }
            case AT_LEAST_ONCE: {
                MqttMessageIdVariableHeader mqttMessageIdVariableHeaderBack = MqttMessageIdVariableHeader.from((int)mqttPublishMessage.variableHeader().packetId());
                MqttFixedHeader mqttFixedHeaderBack = new MqttFixedHeader(MqttMessageType.PUBACK, mqttFixedHeaderInfo.isDup(), MqttQoS.AT_MOST_ONCE, mqttFixedHeaderInfo.isRetain(), 2);
                MqttPubAckMessage pubAck = new MqttPubAckMessage(mqttFixedHeaderBack, mqttMessageIdVariableHeaderBack);
                log.info("\u56de\u5e94 ==> {}", (Object)pubAck);
                channel.writeAndFlush((Object)pubAck);
                this.subscribSend(mqttMessage);
                break;
            }
            case EXACTLY_ONCE: {
                MqttFixedHeader mqttFixedHeaderBack2 = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_LEAST_ONCE, false, 2);
                MqttMessageIdVariableHeader mqttMessageIdVariableHeaderBack2 = MqttMessageIdVariableHeader.from((int)mqttPublishMessage.variableHeader().packetId());
                MqttMessage mqttMessageBack = new MqttMessage(mqttFixedHeaderBack2, (Object)mqttMessageIdVariableHeaderBack2);
                String mqttMessageId = String.valueOf(mqttPublishMessage.variableHeader().packetId());
                if (MQTTMessageContext.hasKey(mqttMessageId)) {
                    log.info("[{}]\u6d88\u606f\u91cd\u590d:[{}]", (Object)mqttPublishMessage.variableHeader().packetId(), (Object)mqttPublishMessage.fixedHeader().isDup());
                    return;
                }
                MQTTMessageContext.put(mqttMessageId, mqttMessage);
                log.info("\u6d88\u606fID[{}] ==> Qos2\u7ea7\u522b\u6d88\u606f\uff0c\u6d88\u606f\u7f13\u5b58", (Object)mqttMessageId);
                mqttPublishMessage.retain();
                channel.writeAndFlush((Object)mqttMessageBack);
                break;
            }
        }
    }

    public void pubcomp(Channel channel, MqttMessage mqttMessage) {
        MqttMessageIdVariableHeader messageIdVariableHeader = (MqttMessageIdVariableHeader)mqttMessage.variableHeader();
        MqttFixedHeader mqttFixedHeaderBack = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 2);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeaderBack = MqttMessageIdVariableHeader.from((int)messageIdVariableHeader.messageId());
        MqttMessage mqttMessageBack = new MqttMessage(mqttFixedHeaderBack, (Object)mqttMessageIdVariableHeaderBack);
        channel.writeAndFlush((Object)mqttMessageBack);
    }

    public void suback(Channel channel, MqttMessage mqttMessage) {
        MqttSubscribeMessage mqttSubscribeMessage = (MqttSubscribeMessage)mqttMessage;
        MqttMessageIdVariableHeader messageIdVariableHeader = mqttSubscribeMessage.variableHeader();
        MqttMessageIdVariableHeader variableHeaderBack = MqttMessageIdVariableHeader.from((int)messageIdVariableHeader.messageId());
        Set<String> topics = mqttSubscribeMessage.payload().topicSubscriptions().stream().map(MqttTopicSubscription::topicFilter).collect(Collectors.toSet());
        MqttSubAckMessage subAck = MqttMsgBack.getMqttSubAckMessage(topics, mqttSubscribeMessage, variableHeaderBack);
        channel.writeAndFlush((Object)subAck);
    }

    public void unsuback(Channel channel, MqttMessage mqttMessage) {
        MqttMessageIdVariableHeader messageIdVariableHeader = (MqttMessageIdVariableHeader)mqttMessage.variableHeader();
        MqttMessageIdVariableHeader variableHeaderBack = MqttMessageIdVariableHeader.from((int)messageIdVariableHeader.messageId());
        MqttFixedHeader mqttFixedHeaderBack = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 2);
        MqttUnsubAckMessage unSubAck = new MqttUnsubAckMessage(mqttFixedHeaderBack, variableHeaderBack);
        channel.writeAndFlush((Object)unSubAck);
    }

    public void pingresp(Channel channel, MqttMessage mqttMessage) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessage mqttMessageBack = new MqttMessage(fixedHeader);
        channel.writeAndFlush((Object)mqttMessageBack);
    }

    public void sub(Channel channel, MqttMessage mqttMessage) {
        MqttSubscribePayload SubscribePayload = (MqttSubscribePayload)mqttMessage.payload();
        for (int i = 0; i < SubscribePayload.topicSubscriptions().size(); ++i) {
            List<ChannelId> channelIds;
            String topicName = ((MqttTopicSubscription)SubscribePayload.topicSubscriptions().get(i)).topicFilter();
            boolean tag = MQTTSubscribeManager.hasSubscribe(topicName);
            if (tag) {
                channelIds = MQTTSubscribeManager.getSubscribe(topicName);
                if (!channelIds.contains(channel.id())) {
                    channelIds.add(channel.id());
                } else {
                    log.warn("[{}]\u91cd\u590d\u8ba2\u9605", (Object)channel.id());
                }
            } else {
                channelIds = new ArrayList<ChannelId>();
                channelIds.add(channel.id());
            }
            MQTTSubscribeManager.registerSubscribe(topicName, channelIds);
            log.info("[{}]\u8ba2\u9605\u5730\u5740 ==> [{}]", (Object)channel.id(), (Object)topicName);
        }
    }

    public void unSub(Channel channel, MqttMessage mqttMessage) {
        Object Unsubscribe = mqttMessage.payload();
        MqttUnsubscribePayload unsubscribePayload = (MqttUnsubscribePayload)Unsubscribe;
        int len = unsubscribePayload.topics().size();
        for (int i = 0; i < len; ++i) {
            String topicName = (String)unsubscribePayload.topics().get(i);
            boolean tag = MQTTSubscribeManager.hasSubscribe(topicName);
            if (tag) {
                MQTTSubscribeManager.removeSubscribe(topicName, channel.id());
            } else {
                log.error("\u4e0d\u5b58\u5728\u8ba2\u9605\u5730\u5740 ==> [{}]", (Object)topicName);
            }
            log.info("[{}]\u53d6\u6d88\u8ba2\u9605\u5730\u5740 ==> [{}]", (Object)channel.id(), (Object)topicName);
        }
    }

    public void subscribSend(MqttMessage mqttMessage) {
        MqttPublishMessage mqttPublishMessage = (MqttPublishMessage)mqttMessage;
        Object obj = mqttMessage.variableHeader();
        MqttPublishVariableHeader variableHeader = (MqttPublishVariableHeader)obj;
        String topicName = variableHeader.topicName();
        int packetId = variableHeader.packetId();
        MqttFixedHeader FixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttPublishVariableHeader mqttPublishVariableHeader = new MqttPublishVariableHeader(topicName, packetId);
        MqttPublishMessage mqttPublishMessageResult = new MqttPublishMessage(FixedHeader, mqttPublishVariableHeader, mqttPublishMessage.content());
        log.info("\u63a8\u9001\u5730\u5740 ==> [{}]", (Object)topicName);
        HashSet set = new HashSet();
        MQTTSubscribeManager.getSubscribeMap().forEach((key, value) -> {
            if (this.matches((String)key, topicName)) {
                set.addAll(value);
            }
        });
        set.forEach(item -> {
            Channel channelSub = ClientManager.getChannel(item);
            if (channelSub != null) {
                mqttPublishMessageResult.retain();
                channelSub.writeAndFlush((Object)mqttPublishMessageResult);
            }
        });
    }

    private boolean matches(String wildcardTopic, String topic) {
        String[] topicParts;
        if (wildcardTopic.equals("#")) {
            return true;
        }
        String[] wildcardParts = wildcardTopic.split("/");
        if (wildcardParts.length != (topicParts = topic.split("/")).length && !wildcardTopic.endsWith("#")) {
            return false;
        }
        for (int i = 0; i < wildcardParts.length; ++i) {
            if ("+".equals(wildcardParts[i])) continue;
            if ("#".equals(wildcardParts[i])) {
                return true;
            }
            if (wildcardParts[i].equals(topicParts[i])) continue;
            return false;
        }
        return true;
    }
}

