package com.af.v4.system.common.socket.config;

import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;

import java.util.List;

/**
 * Socket客户端
 *
 * @author Mr.river
 */
public class SocketClientConfigItem extends  SocketConfigItem{

    /**
     * 服务端类型(tcp,udp)
     */
    private String host;

    /**
     * 服务端类型(tcp,udp)
     */
    private SocketTypeEnum type;
    /**
     * 服务端名称
     */
    private String name;
    /**
     * 连接端口集合
     */
    private Integer ports;
    /**
     * 请求数据返回执行的logic名称
     */
    private String logicName;
    /**
     * 编码类型
     */
    private MsgTypeEnum encodeType;
    /**
     * 解码类型
     */
    private MsgTypeEnum decodeType;
    /**
     * 连接超时时间 单位 秒
     */
    private Integer connectionTimeout;
    /**
     * 读取数据超时时间 单位 秒
     */
    private Integer readTimeout;
    /**
     * 要执行的事件
     */
    private List<ClientEvent> events;


    public String getHost() {
        return host;
    }

    public SocketClientConfigItem setHost(String host) {
        this.host = host;
        return this;
    }

    public SocketTypeEnum getType() {
        return type;
    }


    public SocketClientConfigItem setType(SocketTypeEnum type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return name;
    }

    public SocketClientConfigItem setName(String name) {
        this.name = name;
        return this;
    }

    public Integer getPort() {
        return ports;
    }

    public SocketClientConfigItem setPorts(Integer ports) {
        this.ports = ports;
        return this;
    }

    public String getLogicName() {
        return logicName;
    }

    public SocketClientConfigItem setLogicName(String logicName) {
        this.logicName = logicName;
        return this;
    }

    public MsgTypeEnum getEncodeType() {
        return encodeType;
    }

    public SocketClientConfigItem setEncodeType(MsgTypeEnum encodeType) {
        this.encodeType = encodeType;
        return this;
    }

    public MsgTypeEnum getDecodeType() {
        return decodeType;
    }

    public SocketClientConfigItem setDecodeType(MsgTypeEnum decodeType) {
        this.decodeType = decodeType;
        return this;
    }

    public Integer getConnectionTimeout() {
        return connectionTimeout;
    }

    public SocketClientConfigItem setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Integer getReadTimeout() {
        return readTimeout;
    }

    public SocketClientConfigItem setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public String getAddress(){
        return type + "/" + host + ":" + ports;
    }
    public String getAddress(String alias){
        return  type + "/" + host + ":" + ports + "/" + alias;
    }

    public List<ClientEvent> getEvents() {
        return events;
    }

    public SocketClientConfigItem setEvents(List<ClientEvent> events) {
        this.events = events;
        return this;
    }

    @Override
    public String toString() {
        return "SocketClientConfigItem{" +
                "host='" + host + '\'' +
                ", type=" + type +
                ", name='" + name + '\'' +
                ", ports=" + ports +
                ", logicName='" + logicName + '\'' +
                ", events='" + events.size() + '\'' +
                '}';
    }
}
