/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.client;

import com.af.v4.system.common.socket.config.SocketClientConfigItem;
import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ChannelManager {
    public static final ConcurrentHashMap<String, List<ChannelId>> subscribeMap = new ConcurrentHashMap();
    public static final Map<String, String> MQTTdeviceMap = new ConcurrentHashMap<String, String>();
    public static final ConcurrentHashMap<Integer, MqttMessage> mqttMessageIdMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Channel> channelMap = new ConcurrentHashMap(128);
    private static final Logger log = LoggerFactory.getLogger(ChannelManager.class);

    public static ConcurrentHashMap<String, Channel> getChannelMap() {
        return channelMap;
    }

    public static Channel getChannel(String channelId) {
        if (CollectionUtils.isEmpty(channelMap)) {
            return null;
        }
        return channelMap.get(channelId);
    }

    public static void add(SocketClientConfigItem socketClientConfigItem, Channel channel) {
        channelMap.put(socketClientConfigItem.getAddress(), channel);
    }

    public static void add(ChannelId channelId, Channel channel) {
        channelMap.put(String.valueOf(channelId), channel);
    }

    public static boolean removeChannel(String channelId) {
        if (channelMap.containsKey(channelId)) {
            channelMap.remove(channelId);
            return true;
        }
        return false;
    }

    public static void MQTTremoveChannel(ChannelId channelId) {
        String channelIdStr = channelId.asLongText();
        if (channelMap.containsKey(channelIdStr)) {
            channelMap.remove(channelIdStr);
            MQTTdeviceMap.entrySet().removeIf(item -> ((String)item.getValue()).equals(channelIdStr));
            for (Map.Entry<String, List<ChannelId>> listEntry : subscribeMap.entrySet()) {
                try {
                    if (!listEntry.getValue().contains(channelId)) continue;
                    listEntry.getValue().remove(channelId);
                    log.info("{}\u4e0b\u7ebf,topic:  {}\u4e2d\u79fb\u9664\u6b64id", (Object)channelId, (Object)listEntry.getKey());
                }
                catch (Exception e) {
                    log.error("\u79fb\u9664\u8bbe\u5907\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public static List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtils.isEmpty(channelMap)) {
            return null;
        }
        for (Map.Entry<String, Channel> iterator : channelMap.entrySet()) {
            String channelId = iterator.getKey();
            list.add(channelId);
        }
        return list;
    }
}

