/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.udp;

import com.af.v4.system.common.core.enums.OSType;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.socket.core.channel.impl.DatagramPacketChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketServer;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import jakarta.annotation.PreDestroy;

public class UdpServer
extends SocketServer<Bootstrap, Channel> {
    private EventLoopGroup group;

    @Override
    protected AbstractBootstrap<Bootstrap, Channel> initBootstrap() {
        Class<EpollDatagramChannel> channelClass;
        if (ApplicationService.getOSType() == OSType.LINUX) {
            this.group = new EpollEventLoopGroup();
            channelClass = EpollDatagramChannel.class;
        } else {
            this.group = new NioEventLoopGroup();
            channelClass = NioDatagramChannel.class;
        }
        return ((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(channelClass)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(this){

            protected void initChannel(DatagramChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new DatagramPacketChannelHandler()});
            }
        });
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.group.shutdownGracefully();
    }
}

