/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.channel.impl;

import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.plugins.core.ConvertTools;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.channel.AbstractChannelHandler;
import com.af.v4.system.common.socket.core.client.ClientManager;
import com.af.v4.system.common.socket.enums.MsgTypeEnum;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramPacketChannelHandler
extends AbstractChannelHandler<DatagramPacket> {
    private final Logger LOGGER = LoggerFactory.getLogger(DatagramPacketChannelHandler.class);

    @Override
    @Log(title="UDP\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    protected void read(ChannelHandlerContext ctx, DatagramPacket message) {
        SocketConfigItem configItem = ClientManager.getConfig();
        String address = configItem.getType().equals((Object)SocketTypeEnum.UDP) || ctx.channel().remoteAddress() == null ? ((InetSocketAddress)message.sender()).toString() : ctx.channel().remoteAddress().toString();
        Object response = this.runBusiness((ByteBuf)message.content(), address);
        if (response == null || response.equals("ok") || response.equals("6f6b")) {
            return;
        }
        String responseStr = response.toString();
        byte[] respBytes = switch (configItem.getEncodeType()) {
            case MsgTypeEnum.BASE64 -> ConvertTools.base64Decode((byte[])responseStr.getBytes());
            case MsgTypeEnum.HEX -> ConvertTools.hexStrToByte((String)responseStr);
            case MsgTypeEnum.HEX_BASE64 -> ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)responseStr));
            default -> responseStr.getBytes(StandardCharsets.UTF_8);
        };
        DatagramPacket packet = new DatagramPacket(new UnpooledByteBufAllocator(true).buffer().writeBytes(respBytes), (InetSocketAddress)message.sender());
        ctx.writeAndFlush((Object)packet);
    }
}

