/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket.core.server.modbus;

import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.enums.OSTypeEnum;
import com.af.v4.system.common.socket.core.channel.impl.ModbusRequestDecoder;
import com.af.v4.system.common.socket.core.channel.impl.ModbusResponseEncoder;
import com.af.v4.system.common.socket.core.channel.impl.ModbusTCPChannelHandler;
import com.af.v4.system.common.socket.core.server.SocketServer;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import jakarta.annotation.PreDestroy;

public class ModBusServer
extends SocketServer<ServerBootstrap, ServerChannel> {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    @Override
    protected AbstractBootstrap<ServerBootstrap, ServerChannel> initBootstrap() {
        Class<EpollServerSocketChannel> channelClass;
        if (ApplicationUtils.getOSType() == OSTypeEnum.LINUX) {
            this.bossGroup = new EpollEventLoopGroup();
            this.workerGroup = new EpollEventLoopGroup();
            channelClass = EpollServerSocketChannel.class;
        } else {
            this.bossGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
            channelClass = NioServerSocketChannel.class;
        }
        return ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(channelClass)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusRequestDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusResponseEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new ModbusTCPChannelHandler()});
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.TCP_NODELAY, (Object)false).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }
}

