/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.socket;

import com.af.v4.system.common.socket.config.SocketConfig;
import com.af.v4.system.common.socket.config.SocketConfigItem;
import com.af.v4.system.common.socket.core.server.SocketServer;
import com.af.v4.system.common.socket.core.server.modbus.ModBusServer;
import com.af.v4.system.common.socket.core.server.tcp.TcpServer;
import com.af.v4.system.common.socket.core.server.udp.UdpServer;
import com.af.v4.system.common.socket.enums.SocketTypeEnum;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SocketServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketServerManager.class);
    private static final Map<String, SocketConfigItem> socketConfigMap = new HashMap<String, SocketConfigItem>();
    private final SocketConfig socketConfig;
    private final List<SocketServer<?, ?>> socketServerList = new ArrayList();

    public SocketServerManager(SocketConfig socketConfig) {
        this.socketConfig = socketConfig;
    }

    public static SocketConfigItem getSocketConfigItemByPort(String port) {
        return socketConfigMap.get(port);
    }

    @PostConstruct
    public void startAll() {
        List<SocketConfigItem> socketConfigItemList = this.socketConfig.getSocketServerList();
        if (socketConfigItemList != null) {
            socketConfigItemList.forEach(item -> {
                SocketServer<?, ?> socketServer = this.createSocketServer((SocketConfigItem)item);
                this.socketServerList.add(socketServer);
                item.getPorts().forEach(port -> socketConfigMap.put(port.toString(), (SocketConfigItem)item));
                if (socketServer != null) {
                    socketServer.run((SocketConfigItem)item);
                }
            });
        }
    }

    private SocketServer<?, ?> createSocketServer(SocketConfigItem item) {
        SocketServer socketServer = null;
        if (item.getType() == SocketTypeEnum.TCP) {
            socketServer = new TcpServer();
        } else if (item.getType() == SocketTypeEnum.UDP) {
            socketServer = new UdpServer();
        } else if (item.getType() == SocketTypeEnum.MODBUS_TCP) {
            socketServer = new ModBusServer();
        }
        return socketServer;
    }

    @PreDestroy
    public void destroyAll() {
        for (SocketServer<?, ?> socketServer : this.socketServerList) {
            socketServer.destroy();
        }
    }
}

